/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import androidx.annotation.NonNull;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.internal.ClassHelper;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SamsungPayConfiguration {
    private static final String SAMSUNG_PAY_CLASSNAME = "com.braintreepayments.api.SamsungPay";
    private static final String DISPLAY_NAME_KEY = "displayName";
    private static final String SERVICE_ID_KEY = "serviceId";
    private static final String SUPPORTED_CARD_BRANDS_KEY = "supportedCardBrands";
    private static final String SAMSUNG_AUTHORIZATION_KEY = "samsungAuthorization";
    private static final String ENVIRONMENT = "environment";
    private Set<String> mSupportedCardBrands = new HashSet<String>();
    private String mMerchantDisplayName;
    private String mServiceId;
    private String mSamsungAuthorization;
    private String mEnvironment;

    static SamsungPayConfiguration fromJson(JSONObject json) {
        SamsungPayConfiguration configuration = new SamsungPayConfiguration();
        if (json == null) {
            json = new JSONObject();
        }
        configuration.mMerchantDisplayName = Json.optString((JSONObject)json, (String)DISPLAY_NAME_KEY, (String)"");
        configuration.mServiceId = Json.optString((JSONObject)json, (String)SERVICE_ID_KEY, (String)"");
        try {
            JSONArray supportedCardBrands = json.getJSONArray(SUPPORTED_CARD_BRANDS_KEY);
            for (int i = 0; i < supportedCardBrands.length(); ++i) {
                configuration.mSupportedCardBrands.add(supportedCardBrands.getString(i));
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        configuration.mSamsungAuthorization = Json.optString((JSONObject)json, (String)SAMSUNG_AUTHORIZATION_KEY, (String)"");
        configuration.mEnvironment = Json.optString((JSONObject)json, (String)ENVIRONMENT, (String)"");
        return configuration;
    }

    public boolean isEnabled() {
        return !"".equals(this.mSamsungAuthorization) && ClassHelper.isClassAvailable((String)SAMSUNG_PAY_CLASSNAME);
    }

    @NonNull
    public String getMerchantDisplayName() {
        return this.mMerchantDisplayName;
    }

    @NonNull
    public String getServiceId() {
        return this.mServiceId;
    }

    @NonNull
    public Set<String> getSupportedCardBrands() {
        return this.mSupportedCardBrands;
    }

    @NonNull
    public String getSamsungAuthorization() {
        return this.mSamsungAuthorization;
    }

    public String getEnvironment() {
        return this.mEnvironment;
    }
}

