/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import org.json.JSONException;
import org.json.JSONObject;

public class PreferredPaymentMethodsResult {
    private boolean mPayPalPreferred;
    private boolean mVenmoPreferred;

    public static PreferredPaymentMethodsResult fromJSON(String responseBody, boolean venmoInstalled) {
        boolean payPalPreferred = false;
        try {
            JSONObject response = new JSONObject(responseBody);
            JSONObject preferredPaymentMethods = PreferredPaymentMethodsResult.getObjectAtKeyPath(response, "data.preferredPaymentMethods");
            if (preferredPaymentMethods != null) {
                payPalPreferred = preferredPaymentMethods.getBoolean("paypalPreferred");
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return new PreferredPaymentMethodsResult().isPayPalPreferred(payPalPreferred).isVenmoPreferred(venmoInstalled);
    }

    public PreferredPaymentMethodsResult isPayPalPreferred(boolean payPalPreferred) {
        this.mPayPalPreferred = payPalPreferred;
        return this;
    }

    public PreferredPaymentMethodsResult isVenmoPreferred(boolean venmoPreferred) {
        this.mVenmoPreferred = venmoPreferred;
        return this;
    }

    public boolean isPayPalPreferred() {
        return this.mPayPalPreferred;
    }

    public boolean isVenmoPreferred() {
        return this.mVenmoPreferred;
    }

    private static JSONObject getObjectAtKeyPath(JSONObject obj, String keyPath) throws JSONException {
        String[] keys = keyPath.split("\\.");
        JSONObject result = obj;
        for (String key : keys) {
            result = result.getJSONObject(key);
        }
        return result;
    }
}

