/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Base64;
import com.braintreepayments.api.exceptions.InvalidArgumentException;
import com.braintreepayments.api.models.Authorization;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PayPalUAT
extends Authorization {
    protected static final String MATCHER = "^[a-zA-Z0-9]+\\.[a-zA-Z0-9]+\\.[a-zA-Z0-9_-]+$";
    private static final String EXTERNAL_ID_STRING = "external_id";
    private String mConfigUrl;
    private String mPayPalUrl;
    private String mBraintreeMerchantID;
    private String mToken;
    private Environment mEnvironment;
    public static final Parcelable.Creator<PayPalUAT> CREATOR = new Parcelable.Creator<PayPalUAT>(){

        public PayPalUAT createFromParcel(Parcel source) {
            return new PayPalUAT(source);
        }

        public PayPalUAT[] newArray(int size) {
            return new PayPalUAT[size];
        }
    };

    PayPalUAT(String uatString) throws InvalidArgumentException {
        super(uatString);
        this.mToken = uatString;
        try {
            String decodedUATString = this.decodeUATString(uatString);
            JSONObject jsonObject = new JSONObject(decodedUATString);
            JSONArray externalIDs = jsonObject.getJSONArray(EXTERNAL_ID_STRING);
            for (int i = 0; i < externalIDs.length(); ++i) {
                if (!externalIDs.getString(i).startsWith("Braintree:")) continue;
                this.mBraintreeMerchantID = externalIDs.getString(i).split(":")[1];
                break;
            }
            if (TextUtils.isEmpty((CharSequence)this.mBraintreeMerchantID)) {
                throw new IllegalArgumentException("Missing Braintree merchant account ID.");
            }
            if (!jsonObject.has("iss")) {
                throw new IllegalArgumentException("Does not contain issuer, or \"iss\" key.");
            }
            this.mPayPalUrl = jsonObject.getString("iss");
            this.mEnvironment = this.determineIssuerEnv();
            this.mConfigUrl = this.generateConfigUrl();
        }
        catch (IllegalArgumentException | NullPointerException | JSONException e) {
            throw new InvalidArgumentException("PayPal UAT invalid: " + e.getMessage());
        }
    }

    private String decodeUATString(String uat) {
        String[] uatComponents = uat.split("[.]");
        return new String(Base64.decode((String)uatComponents[1], (int)0));
    }

    private String generateConfigUrl() {
        String baseBraintreeURL = this.mEnvironment == Environment.STAGING || this.mEnvironment == Environment.SANDBOX ? "https://api.sandbox.braintreegateway.com:443/merchants/" : "https://api.braintreegateway.com:443/merchants/";
        return baseBraintreeURL + this.mBraintreeMerchantID + "/client_api/v1/configuration";
    }

    private Environment determineIssuerEnv() throws IllegalArgumentException {
        switch (this.mPayPalUrl) {
            case "https://api.paypal.com": {
                return Environment.PRODUCTION;
            }
            case "https://api.sandbox.paypal.com": {
                return Environment.SANDBOX;
            }
            case "https://api.msmaster.qa.paypal.com": {
                return Environment.STAGING;
            }
        }
        throw new IllegalArgumentException("PayPal issuer URL missing or unknown: " + this.mPayPalUrl);
    }

    @Override
    public String getConfigUrl() {
        return this.mConfigUrl;
    }

    @Override
    public String getBearer() {
        return this.mToken;
    }

    public String getPayPalURL() {
        return this.mPayPalUrl;
    }

    public Environment getEnvironment() {
        return this.mEnvironment;
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mConfigUrl);
        dest.writeString(this.mPayPalUrl);
        dest.writeString(this.mToken);
        dest.writeString(this.mBraintreeMerchantID);
    }

    protected PayPalUAT(Parcel in) {
        super(in);
        this.mConfigUrl = in.readString();
        this.mPayPalUrl = in.readString();
        this.mToken = in.readString();
        this.mBraintreeMerchantID = in.readString();
    }

    public static enum Environment {
        STAGING,
        SANDBOX,
        PRODUCTION;

    }
}

