/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.braintreepayments.api.models.PayPalProductAttributes;
import com.braintreepayments.api.models.PostalAddress;
import com.paypal.android.sdk.onetouch.core.PayPalLineItem;
import java.util.ArrayList;
import java.util.Collection;

public class PayPalRequest
implements Parcelable {
    public static final String INTENT_ORDER = "order";
    public static final String INTENT_SALE = "sale";
    public static final String INTENT_AUTHORIZE = "authorize";
    public static final String LANDING_PAGE_TYPE_BILLING = "billing";
    public static final String LANDING_PAGE_TYPE_LOGIN = "login";
    public static final String USER_ACTION_DEFAULT = "";
    public static final String USER_ACTION_COMMIT = "commit";
    private String mAmount;
    private String mCurrencyCode;
    private String mLocaleCode;
    private String mBillingAgreementDescription;
    private boolean mShippingAddressRequired;
    private boolean mShippingAddressEditable = false;
    private PostalAddress mShippingAddressOverride;
    private String mIntent = "authorize";
    private String mLandingPageType;
    private String mUserAction = "";
    private String mDisplayName;
    private boolean mOfferCredit;
    private String mMerchantAccountId;
    private PayPalProductAttributes mProductAttributes;
    private ArrayList<PayPalLineItem> mLineItems = new ArrayList();
    public static final Parcelable.Creator<PayPalRequest> CREATOR = new Parcelable.Creator<PayPalRequest>(){

        public PayPalRequest createFromParcel(Parcel in) {
            return new PayPalRequest(in);
        }

        public PayPalRequest[] newArray(int size) {
            return new PayPalRequest[size];
        }
    };

    public PayPalRequest(String amount) {
        this.mAmount = amount;
        this.mShippingAddressRequired = false;
        this.mOfferCredit = false;
    }

    public PayPalRequest() {
        this.mAmount = null;
        this.mShippingAddressRequired = false;
        this.mOfferCredit = false;
    }

    public PayPalRequest currencyCode(String currencyCode) {
        this.mCurrencyCode = currencyCode;
        return this;
    }

    public PayPalRequest shippingAddressRequired(boolean shippingAddressRequired) {
        this.mShippingAddressRequired = shippingAddressRequired;
        return this;
    }

    public PayPalRequest shippingAddressEditable(boolean shippingAddressEditable) {
        this.mShippingAddressEditable = shippingAddressEditable;
        return this;
    }

    public PayPalRequest localeCode(String localeCode) {
        this.mLocaleCode = localeCode;
        return this;
    }

    public PayPalRequest displayName(String displayName) {
        this.mDisplayName = displayName;
        return this;
    }

    public PayPalRequest billingAgreementDescription(String description) {
        this.mBillingAgreementDescription = description;
        return this;
    }

    public PayPalRequest shippingAddressOverride(PostalAddress shippingAddressOverride) {
        this.mShippingAddressOverride = shippingAddressOverride;
        return this;
    }

    public PayPalRequest intent(String intent) {
        this.mIntent = intent;
        return this;
    }

    public PayPalRequest landingPageType(String landingPageType) {
        this.mLandingPageType = landingPageType;
        return this;
    }

    public PayPalRequest userAction(String userAction) {
        this.mUserAction = userAction;
        return this;
    }

    public PayPalRequest offerCredit(boolean offerCredit) {
        this.mOfferCredit = offerCredit;
        return this;
    }

    public PayPalRequest merchantAccountId(String merchantAccountId) {
        this.mMerchantAccountId = merchantAccountId;
        return this;
    }

    public PayPalRequest lineItems(Collection<PayPalLineItem> lineItems) {
        this.mLineItems.clear();
        this.mLineItems.addAll(lineItems);
        return this;
    }

    public PayPalRequest productAttributes(PayPalProductAttributes productAttributes) {
        this.mProductAttributes = productAttributes;
        return this;
    }

    public String getAmount() {
        return this.mAmount;
    }

    public String getCurrencyCode() {
        return this.mCurrencyCode;
    }

    public String getLocaleCode() {
        return this.mLocaleCode;
    }

    public String getBillingAgreementDescription() {
        return this.mBillingAgreementDescription;
    }

    public boolean isShippingAddressRequired() {
        return this.mShippingAddressRequired;
    }

    public boolean isShippingAddressEditable() {
        return this.mShippingAddressEditable;
    }

    public PostalAddress getShippingAddressOverride() {
        return this.mShippingAddressOverride;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public boolean shouldOfferCredit() {
        return this.mOfferCredit;
    }

    public String getMerchantAccountId() {
        return this.mMerchantAccountId;
    }

    public ArrayList<PayPalLineItem> getLineItems() {
        return this.mLineItems;
    }

    public PayPalProductAttributes getProductAttributes() {
        return this.mProductAttributes;
    }

    public String getIntent() {
        return this.mIntent;
    }

    public String getLandingPageType() {
        return this.mLandingPageType;
    }

    public String getUserAction() {
        return this.mUserAction;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.mAmount);
        parcel.writeString(this.mCurrencyCode);
        parcel.writeString(this.mLocaleCode);
        parcel.writeString(this.mBillingAgreementDescription);
        parcel.writeByte(this.mShippingAddressRequired ? (byte)1 : 0);
        parcel.writeByte(this.mShippingAddressEditable ? (byte)1 : 0);
        parcel.writeParcelable((Parcelable)this.mShippingAddressOverride, i);
        parcel.writeString(this.mIntent);
        parcel.writeString(this.mLandingPageType);
        parcel.writeString(this.mUserAction);
        parcel.writeString(this.mDisplayName);
        parcel.writeByte(this.mOfferCredit ? (byte)1 : 0);
        parcel.writeString(this.mMerchantAccountId);
        parcel.writeList(this.mLineItems);
        parcel.writeParcelable((Parcelable)this.mProductAttributes, i);
    }

    public PayPalRequest(Parcel in) {
        this.mAmount = in.readString();
        this.mCurrencyCode = in.readString();
        this.mLocaleCode = in.readString();
        this.mBillingAgreementDescription = in.readString();
        this.mShippingAddressRequired = in.readByte() > 0;
        this.mShippingAddressEditable = in.readByte() > 0;
        this.mShippingAddressOverride = (PostalAddress)in.readParcelable(PostalAddress.class.getClassLoader());
        this.mIntent = in.readString();
        this.mLandingPageType = in.readString();
        this.mUserAction = in.readString();
        this.mDisplayName = in.readString();
        this.mOfferCredit = in.readByte() > 0;
        this.mMerchantAccountId = in.readString();
        this.mLineItems = in.readArrayList(PayPalLineItem.class.getClassLoader());
        this.mProductAttributes = (PayPalProductAttributes)in.readParcelable(PayPalProductAttributes.class.getClassLoader());
    }
}

