/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.braintreepayments.api.models.PostalAddress;
import com.braintreepayments.api.models.PostalAddressParser;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalPaymentResult
extends PaymentMethodNonce
implements Parcelable {
    protected static final String TYPE = "PayPalAccount";
    protected static final String API_RESOURCE_KEY = "paypalAccounts";
    private static final String DETAILS_KEY = "details";
    private static final String EMAIL_KEY = "email";
    private static final String PAYER_INFO_KEY = "payerInfo";
    private static final String ACCOUNT_ADDRESS_KEY = "accountAddress";
    private static final String SHIPPING_ADDRESS_KEY = "shippingAddress";
    private static final String BILLING_ADDRESS_KEY = "billingAddress";
    private static final String FIRST_NAME_KEY = "firstName";
    private static final String LAST_NAME_KEY = "lastName";
    private static final String PHONE_KEY = "phone";
    private static final String PAYER_ID_KEY = "payerId";
    private static final String CLIENT_METADATA_ID_KEY = "correlationId";
    private static final String TYPE_KEY = "type";
    private String mClientMetadataId;
    private PostalAddress mBillingAddress;
    private PostalAddress mShippingAddress;
    private String mGivenName;
    private String mSurname;
    private String mPhone;
    private String mEmail;
    private String mPayerId;
    private String mType;
    public static final Parcelable.Creator<LocalPaymentResult> CREATOR = new Parcelable.Creator<LocalPaymentResult>(){

        public LocalPaymentResult createFromParcel(Parcel source) {
            return new LocalPaymentResult(source);
        }

        public LocalPaymentResult[] newArray(int size) {
            return new LocalPaymentResult[size];
        }
    };

    public static LocalPaymentResult fromJson(String json) throws JSONException {
        LocalPaymentResult localPaymentResult = new LocalPaymentResult();
        localPaymentResult.fromJson(LocalPaymentResult.getJsonObjectForType(API_RESOURCE_KEY, new JSONObject(json)));
        return localPaymentResult;
    }

    @Override
    protected void fromJson(JSONObject json) throws JSONException {
        super.fromJson(json);
        JSONObject details = json.getJSONObject(DETAILS_KEY);
        this.mEmail = Json.optString((JSONObject)details, (String)EMAIL_KEY, null);
        this.mClientMetadataId = Json.optString((JSONObject)details, (String)CLIENT_METADATA_ID_KEY, null);
        this.mType = Json.optString((JSONObject)json, (String)TYPE_KEY, (String)TYPE);
        try {
            JSONObject payerInfo = details.getJSONObject(PAYER_INFO_KEY);
            JSONObject billingAddress = payerInfo.has(ACCOUNT_ADDRESS_KEY) ? payerInfo.optJSONObject(ACCOUNT_ADDRESS_KEY) : payerInfo.optJSONObject(BILLING_ADDRESS_KEY);
            JSONObject shippingAddress = payerInfo.optJSONObject(SHIPPING_ADDRESS_KEY);
            this.mBillingAddress = PostalAddressParser.fromJson(billingAddress);
            this.mShippingAddress = PostalAddressParser.fromJson(shippingAddress);
            this.mGivenName = Json.optString((JSONObject)payerInfo, (String)FIRST_NAME_KEY, (String)"");
            this.mSurname = Json.optString((JSONObject)payerInfo, (String)LAST_NAME_KEY, (String)"");
            this.mPhone = Json.optString((JSONObject)payerInfo, (String)PHONE_KEY, (String)"");
            this.mPayerId = Json.optString((JSONObject)payerInfo, (String)PAYER_ID_KEY, (String)"");
            if (this.mEmail == null) {
                this.mEmail = Json.optString((JSONObject)payerInfo, (String)EMAIL_KEY, null);
            }
        }
        catch (JSONException e) {
            this.mBillingAddress = new PostalAddress();
            this.mShippingAddress = new PostalAddress();
        }
    }

    public String getEmail() {
        return this.mEmail;
    }

    @Override
    public String getDescription() {
        return super.getDescription();
    }

    @Override
    public String getTypeLabel() {
        return this.mType;
    }

    public PostalAddress getBillingAddress() {
        return this.mBillingAddress;
    }

    public PostalAddress getShippingAddress() {
        return this.mShippingAddress;
    }

    public String getGivenName() {
        return this.mGivenName;
    }

    public String getSurname() {
        return this.mSurname;
    }

    public String getPhone() {
        return this.mPhone;
    }

    public String getClientMetadataId() {
        return this.mClientMetadataId;
    }

    public String getPayerId() {
        return this.mPayerId;
    }

    public LocalPaymentResult() {
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mClientMetadataId);
        dest.writeParcelable((Parcelable)this.mBillingAddress, flags);
        dest.writeParcelable((Parcelable)this.mShippingAddress, flags);
        dest.writeString(this.mGivenName);
        dest.writeString(this.mSurname);
        dest.writeString(this.mEmail);
        dest.writeString(this.mPhone);
        dest.writeString(this.mPayerId);
        dest.writeString(this.mType);
    }

    private LocalPaymentResult(Parcel in) {
        super(in);
        this.mClientMetadataId = in.readString();
        this.mBillingAddress = (PostalAddress)in.readParcelable(PostalAddress.class.getClassLoader());
        this.mShippingAddress = (PostalAddress)in.readParcelable(PostalAddress.class.getClassLoader());
        this.mGivenName = in.readString();
        this.mSurname = in.readString();
        this.mEmail = in.readString();
        this.mPhone = in.readString();
        this.mPayerId = in.readString();
        this.mType = in.readString();
    }
}

