/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import com.braintreepayments.api.models.PostalAddress;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalPaymentRequest {
    private static final String INTENT_KEY = "intent";
    private static final String RETURN_URL_KEY = "returnUrl";
    private static final String CANCEL_URL_KEY = "cancelUrl";
    private static final String EXPERIENCE_PROFILE_KEY = "experienceProfile";
    private static final String NO_SHIPPING_KEY = "noShipping";
    private static final String FUNDING_SOURCE_KEY = "fundingSource";
    private static final String AMOUNT_KEY = "amount";
    private static final String CURRENCY_CODE_KEY = "currencyIsoCode";
    private static final String GIVEN_NAME_KEY = "firstName";
    private static final String SURNAME_KEY = "lastName";
    private static final String EMAIL_KEY = "payerEmail";
    private static final String PHONE_KEY = "phone";
    private static final String STREET_ADDRESS_KEY = "line1";
    private static final String EXTENDED_ADDRESS_KEY = "line2";
    private static final String LOCALITY_KEY = "city";
    private static final String REGION_KEY = "state";
    private static final String POSTAL_CODE_KEY = "postalCode";
    private static final String COUNTRY_CODE_KEY = "countryCode";
    private static final String MERCHANT_ACCOUNT_ID_KEY = "merchantAccountId";
    private PostalAddress mAddress;
    private String mAmount;
    private String mApprovalUrl;
    private String mCurrencyCode;
    private String mEmail;
    private String mGivenName;
    private String mMerchantAccountId;
    private String mPaymentId;
    private String mPaymentType;
    private String mPhone;
    private boolean mShippingAddressRequired;
    private String mSurname;

    public LocalPaymentRequest address(PostalAddress address) {
        this.mAddress = address;
        return this;
    }

    public LocalPaymentRequest amount(String amount) {
        this.mAmount = amount;
        return this;
    }

    public LocalPaymentRequest approvalUrl(String approvalUrl) {
        if (this.mApprovalUrl == null) {
            this.mApprovalUrl = approvalUrl;
        }
        return this;
    }

    public LocalPaymentRequest currencyCode(String currencyCode) {
        this.mCurrencyCode = currencyCode;
        return this;
    }

    public LocalPaymentRequest email(String email) {
        this.mEmail = email;
        return this;
    }

    public LocalPaymentRequest givenName(String givenName) {
        this.mGivenName = givenName;
        return this;
    }

    public LocalPaymentRequest merchantAccountId(String merchantAccountId) {
        this.mMerchantAccountId = merchantAccountId;
        return this;
    }

    public LocalPaymentRequest paymentId(String paymentId) {
        if (this.mPaymentId == null) {
            this.mPaymentId = paymentId;
        }
        return this;
    }

    public LocalPaymentRequest paymentType(String paymentType) {
        this.mPaymentType = paymentType;
        return this;
    }

    public LocalPaymentRequest phone(String phone) {
        this.mPhone = phone;
        return this;
    }

    public LocalPaymentRequest shippingAddressRequired(boolean shippingAddressRequired) {
        this.mShippingAddressRequired = shippingAddressRequired;
        return this;
    }

    public LocalPaymentRequest surname(String surname) {
        this.mSurname = surname;
        return this;
    }

    public PostalAddress getAddress() {
        return this.mAddress;
    }

    public String getAmount() {
        return this.mAmount;
    }

    public String getApprovalUrl() {
        return this.mApprovalUrl;
    }

    public String getCurrencyCode() {
        return this.mCurrencyCode;
    }

    public String getEmail() {
        return this.mEmail;
    }

    public String getGivenName() {
        return this.mGivenName;
    }

    public String getMerchantAccountId() {
        return this.mMerchantAccountId;
    }

    public String getPaymentId() {
        return this.mPaymentId;
    }

    public String getPaymentType() {
        return this.mPaymentType;
    }

    public String getPhone() {
        return this.mPhone;
    }

    public boolean getShippingAddressRequired() {
        return this.mShippingAddressRequired;
    }

    public String getSurname() {
        return this.mSurname;
    }

    public String build(String returnUrl, String cancelUrl) {
        try {
            JSONObject payload = new JSONObject().put(INTENT_KEY, (Object)"sale").put(RETURN_URL_KEY, (Object)returnUrl).put(CANCEL_URL_KEY, (Object)cancelUrl).put(FUNDING_SOURCE_KEY, (Object)this.mPaymentType).put(AMOUNT_KEY, (Object)this.mAmount).put(CURRENCY_CODE_KEY, (Object)this.mCurrencyCode).put(GIVEN_NAME_KEY, (Object)this.mGivenName).put(SURNAME_KEY, (Object)this.mSurname).put(EMAIL_KEY, (Object)this.mEmail).put(PHONE_KEY, (Object)this.mPhone).put(MERCHANT_ACCOUNT_ID_KEY, (Object)this.mMerchantAccountId);
            if (this.mAddress != null) {
                payload.put(STREET_ADDRESS_KEY, (Object)this.mAddress.getStreetAddress()).put(EXTENDED_ADDRESS_KEY, (Object)this.mAddress.getExtendedAddress()).put(LOCALITY_KEY, (Object)this.mAddress.getLocality()).put(REGION_KEY, (Object)this.mAddress.getRegion()).put(POSTAL_CODE_KEY, (Object)this.mAddress.getPostalCode()).put(COUNTRY_CODE_KEY, (Object)this.mAddress.getCountryCodeAlpha2());
            }
            JSONObject experienceProfile = new JSONObject();
            experienceProfile.put(NO_SHIPPING_KEY, !this.mShippingAddressRequired);
            payload.put(EXPERIENCE_PROFILE_KEY, (Object)experienceProfile);
            return payload.toString();
        }
        catch (JSONException jSONException) {
            return new JSONObject().toString();
        }
    }
}

