/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.content.Context;
import com.braintreepayments.api.Json;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.wallet.Wallet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GooglePaymentConfiguration {
    private static final String ENABLED_KEY = "enabled";
    private static final String GOOGLE_AUTHORIZATION_FINGERPRINT_KEY = "googleAuthorizationFingerprint";
    private static final String ENVIRONMENT_KEY = "environment";
    private static final String DISPLAY_NAME_KEY = "displayName";
    private static final String SUPPORTED_NETWORKS_KEY = "supportedNetworks";
    private static final String PAYPAL_CLIENT_ID_KEY = "paypalClientId";
    boolean mEnabled;
    String mGoogleAuthorizationFingerprint;
    String mEnvironment;
    String mDisplayName;
    String[] mSupportedNetworks;
    String mPayPalClientId;

    public static GooglePaymentConfiguration fromJson(JSONObject json) {
        if (json == null) {
            json = new JSONObject();
        }
        GooglePaymentConfiguration googlePaymentConfiguration = new GooglePaymentConfiguration();
        googlePaymentConfiguration.mEnabled = json.optBoolean(ENABLED_KEY, false);
        googlePaymentConfiguration.mGoogleAuthorizationFingerprint = Json.optString((JSONObject)json, (String)GOOGLE_AUTHORIZATION_FINGERPRINT_KEY, null);
        googlePaymentConfiguration.mEnvironment = Json.optString((JSONObject)json, (String)ENVIRONMENT_KEY, null);
        googlePaymentConfiguration.mDisplayName = Json.optString((JSONObject)json, (String)DISPLAY_NAME_KEY, (String)"");
        googlePaymentConfiguration.mPayPalClientId = Json.optString((JSONObject)json, (String)PAYPAL_CLIENT_ID_KEY, (String)"");
        JSONArray supportedNetworks = json.optJSONArray(SUPPORTED_NETWORKS_KEY);
        if (supportedNetworks != null) {
            googlePaymentConfiguration.mSupportedNetworks = new String[supportedNetworks.length()];
            for (int i = 0; i < supportedNetworks.length(); ++i) {
                try {
                    googlePaymentConfiguration.mSupportedNetworks[i] = supportedNetworks.getString(i);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        } else {
            googlePaymentConfiguration.mSupportedNetworks = new String[0];
        }
        return googlePaymentConfiguration;
    }

    public boolean isEnabled(Context context) {
        try {
            Class.forName(Wallet.class.getName());
            return this.mEnabled && GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context) == 0;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    public String getGoogleAuthorizationFingerprint() {
        return this.mGoogleAuthorizationFingerprint;
    }

    public String getEnvironment() {
        return this.mEnvironment;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public String[] getSupportedNetworks() {
        return this.mSupportedNetworks;
    }

    public String getPaypalClientId() {
        return this.mPayPalClientId;
    }
}

