/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.models.AnalyticsConfiguration;
import com.braintreepayments.api.models.BraintreeApiConfiguration;
import com.braintreepayments.api.models.CardConfiguration;
import com.braintreepayments.api.models.GooglePaymentConfiguration;
import com.braintreepayments.api.models.GraphQLConfiguration;
import com.braintreepayments.api.models.KountConfiguration;
import com.braintreepayments.api.models.PayPalConfiguration;
import com.braintreepayments.api.models.SamsungPayConfiguration;
import com.braintreepayments.api.models.UnionPayConfiguration;
import com.braintreepayments.api.models.VenmoConfiguration;
import com.braintreepayments.api.models.VisaCheckoutConfiguration;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Configuration {
    private static final String ASSETS_URL_KEY = "assetsUrl";
    private static final String CLIENT_API_URL_KEY = "clientApiUrl";
    private static final String CHALLENGES_KEY = "challenges";
    private static final String ENVIRONMENT_KEY = "environment";
    private static final String MERCHANT_ID_KEY = "merchantId";
    private static final String MERCHANT_ACCOUNT_ID_KEY = "merchantAccountId";
    private static final String ANALYTICS_KEY = "analytics";
    private static final String BRAINTREE_API_KEY = "braintreeApi";
    private static final String PAYPAL_ENABLED_KEY = "paypalEnabled";
    private static final String PAYPAL_KEY = "paypal";
    private static final String KOUNT_KEY = "kount";
    private static final String GOOGLE_PAYMENT_KEY = "androidPay";
    private static final String THREE_D_SECURE_ENABLED_KEY = "threeDSecureEnabled";
    private static final String PAY_WITH_VENMO_KEY = "payWithVenmo";
    private static final String UNIONPAY_KEY = "unionPay";
    private static final String CARD_KEY = "creditCards";
    private static final String VISA_CHECKOUT_KEY = "visaCheckout";
    private static final String GRAPHQL_KEY = "graphQL";
    private static final String SAMSUNG_PAY_KEY = "samsungPay";
    private static final String CARDINAL_AUTHENTICATION_JWT = "cardinalAuthenticationJWT";
    private String mAssetsUrl;
    private String mConfigurationString;
    private String mClientApiUrl;
    private final Set<String> mChallenges = new HashSet<String>();
    private String mEnvironment;
    private String mMerchantId;
    private String mMerchantAccountId;
    private BraintreeApiConfiguration mBraintreeApiConfiguration;
    private AnalyticsConfiguration mAnalyticsConfiguration;
    private CardConfiguration mCardConfiguration;
    private boolean mPaypalEnabled;
    private PayPalConfiguration mPayPalConfiguration;
    private GooglePaymentConfiguration mGooglePaymentConfiguration;
    private boolean mThreeDSecureEnabled;
    private VenmoConfiguration mVenmoConfiguration;
    private KountConfiguration mKountConfiguration;
    private UnionPayConfiguration mUnionPayConfiguration;
    private VisaCheckoutConfiguration mVisaCheckoutConfiguration;
    private GraphQLConfiguration mGraphQLConfiguration;
    private SamsungPayConfiguration mSamsungPayConfiguration;
    private String mCardinalAuthenticationJwt;

    public static Configuration fromJson(@Nullable String configurationString) throws JSONException {
        return new Configuration(configurationString);
    }

    protected Configuration(@Nullable String configurationString) throws JSONException {
        if (configurationString == null) {
            throw new JSONException("Configuration cannot be null");
        }
        this.mConfigurationString = configurationString;
        JSONObject json = new JSONObject(configurationString);
        this.mAssetsUrl = Json.optString((JSONObject)json, (String)ASSETS_URL_KEY, (String)"");
        this.mClientApiUrl = json.getString(CLIENT_API_URL_KEY);
        this.parseJsonChallenges(json.optJSONArray(CHALLENGES_KEY));
        this.mEnvironment = json.getString(ENVIRONMENT_KEY);
        this.mMerchantId = json.getString(MERCHANT_ID_KEY);
        this.mMerchantAccountId = Json.optString((JSONObject)json, (String)MERCHANT_ACCOUNT_ID_KEY, null);
        this.mAnalyticsConfiguration = AnalyticsConfiguration.fromJson(json.optJSONObject(ANALYTICS_KEY));
        this.mBraintreeApiConfiguration = BraintreeApiConfiguration.fromJson(json.optJSONObject(BRAINTREE_API_KEY));
        this.mCardConfiguration = CardConfiguration.fromJson(json.optJSONObject(CARD_KEY));
        this.mPaypalEnabled = json.optBoolean(PAYPAL_ENABLED_KEY, false);
        this.mPayPalConfiguration = PayPalConfiguration.fromJson(json.optJSONObject(PAYPAL_KEY));
        this.mGooglePaymentConfiguration = GooglePaymentConfiguration.fromJson(json.optJSONObject(GOOGLE_PAYMENT_KEY));
        this.mThreeDSecureEnabled = json.optBoolean(THREE_D_SECURE_ENABLED_KEY, false);
        this.mVenmoConfiguration = VenmoConfiguration.fromJson(json.optJSONObject(PAY_WITH_VENMO_KEY));
        this.mKountConfiguration = KountConfiguration.fromJson(json.optJSONObject(KOUNT_KEY));
        this.mUnionPayConfiguration = UnionPayConfiguration.fromJson(json.optJSONObject(UNIONPAY_KEY));
        this.mVisaCheckoutConfiguration = VisaCheckoutConfiguration.fromJson(json.optJSONObject(VISA_CHECKOUT_KEY));
        this.mGraphQLConfiguration = GraphQLConfiguration.fromJson(json.optJSONObject(GRAPHQL_KEY));
        this.mSamsungPayConfiguration = SamsungPayConfiguration.fromJson(json.optJSONObject(SAMSUNG_PAY_KEY));
        this.mCardinalAuthenticationJwt = Json.optString((JSONObject)json, (String)CARDINAL_AUTHENTICATION_JWT, null);
    }

    public String toJson() {
        return this.mConfigurationString;
    }

    public String getAssetsUrl() {
        return this.mAssetsUrl;
    }

    public String getClientApiUrl() {
        return this.mClientApiUrl;
    }

    public boolean isCvvChallengePresent() {
        return this.mChallenges.contains("cvv");
    }

    public boolean isPostalCodeChallengePresent() {
        return this.mChallenges.contains("postal_code");
    }

    public BraintreeApiConfiguration getBraintreeApiConfiguration() {
        return this.mBraintreeApiConfiguration;
    }

    public String getEnvironment() {
        return this.mEnvironment;
    }

    public CardConfiguration getCardConfiguration() {
        return this.mCardConfiguration;
    }

    public boolean isPayPalEnabled() {
        return this.mPaypalEnabled;
    }

    public PayPalConfiguration getPayPal() {
        return this.mPayPalConfiguration;
    }

    public GooglePaymentConfiguration getGooglePayment() {
        return this.mGooglePaymentConfiguration;
    }

    public boolean isThreeDSecureEnabled() {
        return this.mThreeDSecureEnabled;
    }

    public String getMerchantId() {
        return this.mMerchantId;
    }

    public String getMerchantAccountId() {
        return this.mMerchantAccountId;
    }

    public AnalyticsConfiguration getAnalytics() {
        return this.mAnalyticsConfiguration;
    }

    public VenmoConfiguration getPayWithVenmo() {
        return this.mVenmoConfiguration;
    }

    public UnionPayConfiguration getUnionPay() {
        return this.mUnionPayConfiguration;
    }

    public VisaCheckoutConfiguration getVisaCheckout() {
        return this.mVisaCheckoutConfiguration;
    }

    public KountConfiguration getKount() {
        return this.mKountConfiguration;
    }

    public GraphQLConfiguration getGraphQL() {
        return this.mGraphQLConfiguration;
    }

    @NonNull
    public SamsungPayConfiguration getSamsungPay() {
        return this.mSamsungPayConfiguration;
    }

    private void parseJsonChallenges(JSONArray jsonArray) {
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                this.mChallenges.add(jsonArray.optString(i, ""));
            }
        }
    }

    public String getCardinalAuthenticationJwt() {
        return this.mCardinalAuthenticationJwt;
    }
}

