/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.models.AuthenticationInsight;
import com.braintreepayments.api.models.BinData;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.braintreepayments.api.models.ThreeDSecureInfo;
import org.json.JSONException;
import org.json.JSONObject;

public class CardNonce
extends PaymentMethodNonce
implements Parcelable {
    protected static final String TYPE = "CreditCard";
    protected static final String API_RESOURCE_KEY = "creditCards";
    private static final String GRAPHQL_TOKENIZE_CREDIT_CARD_KEY = "tokenizeCreditCard";
    private static final String GRAPHQL_CREDIT_CARD_KEY = "creditCard";
    private static final String GRAPHQL_BRAND_KEY = "brand";
    private static final String GRAPHQL_LAST_FOUR_KEY = "last4";
    private static final String THREE_D_SECURE_INFO_KEY = "threeDSecureInfo";
    private static final String CARD_DETAILS_KEY = "details";
    private static final String CARD_TYPE_KEY = "cardType";
    private static final String LAST_TWO_KEY = "lastTwo";
    private static final String LAST_FOUR_KEY = "lastFour";
    private static final String BIN_KEY = "bin";
    private static final String AUTHENTICATION_INSIGHT_KEY = "authenticationInsight";
    private static final String EXPIRATION_MONTH_KEY = "expirationMonth";
    private static final String EXPIRATION_YEAR_KEY = "expirationYear";
    private static final String CARDHOLDER_NAME_KEY = "cardholderName";
    private String mCardType;
    private String mLastTwo;
    private String mLastFour;
    private ThreeDSecureInfo mThreeDSecureInfo;
    private String mBin;
    private BinData mBinData;
    private AuthenticationInsight mAuthenticationInsight;
    private String mExpirationMonth;
    private String mExpirationYear;
    private String mCardholderName;
    public static final Parcelable.Creator<CardNonce> CREATOR = new Parcelable.Creator<CardNonce>(){

        public CardNonce createFromParcel(Parcel source) {
            return new CardNonce(source);
        }

        public CardNonce[] newArray(int size) {
            return new CardNonce[size];
        }
    };

    public static CardNonce fromJson(String json) throws JSONException {
        CardNonce cardNonce = new CardNonce();
        JSONObject jsonObject = new JSONObject(json);
        if (jsonObject.has("data")) {
            cardNonce.fromGraphQLJson(jsonObject);
        } else {
            cardNonce.fromJson(CardNonce.getJsonObjectForType(API_RESOURCE_KEY, jsonObject));
        }
        return cardNonce;
    }

    @Override
    protected void fromJson(JSONObject json) throws JSONException {
        super.fromJson(json);
        JSONObject details = json.getJSONObject(CARD_DETAILS_KEY);
        this.mLastTwo = details.getString(LAST_TWO_KEY);
        this.mLastFour = details.getString(LAST_FOUR_KEY);
        this.mCardType = details.getString(CARD_TYPE_KEY);
        this.mThreeDSecureInfo = ThreeDSecureInfo.fromJson(json.optJSONObject(THREE_D_SECURE_INFO_KEY));
        this.mBin = Json.optString((JSONObject)details, (String)BIN_KEY, (String)"");
        this.mBinData = BinData.fromJson(json.optJSONObject("binData"));
        this.mAuthenticationInsight = AuthenticationInsight.fromJson(json.optJSONObject(AUTHENTICATION_INSIGHT_KEY));
        this.mExpirationMonth = Json.optString((JSONObject)details, (String)EXPIRATION_MONTH_KEY, (String)"");
        this.mExpirationYear = Json.optString((JSONObject)details, (String)EXPIRATION_YEAR_KEY, (String)"");
        this.mCardholderName = Json.optString((JSONObject)details, (String)CARDHOLDER_NAME_KEY, (String)"");
    }

    private void fromGraphQLJson(JSONObject json) throws JSONException {
        JSONObject data = json.getJSONObject("data");
        if (!data.has(GRAPHQL_TOKENIZE_CREDIT_CARD_KEY)) {
            throw new JSONException("Failed to parse GraphQL response JSON");
        }
        JSONObject payload = data.getJSONObject(GRAPHQL_TOKENIZE_CREDIT_CARD_KEY);
        JSONObject creditCard = payload.getJSONObject(GRAPHQL_CREDIT_CARD_KEY);
        this.mLastFour = Json.optString((JSONObject)creditCard, (String)GRAPHQL_LAST_FOUR_KEY, (String)"");
        this.mLastTwo = this.mLastFour.length() < 4 ? "" : this.mLastFour.substring(2);
        this.mCardType = Json.optString((JSONObject)creditCard, (String)GRAPHQL_BRAND_KEY, (String)"Unknown");
        this.mThreeDSecureInfo = ThreeDSecureInfo.fromJson(null);
        this.mBin = Json.optString((JSONObject)creditCard, (String)BIN_KEY, (String)"");
        this.mBinData = BinData.fromJson(creditCard.optJSONObject("binData"));
        this.mNonce = payload.getString("token");
        this.mDescription = TextUtils.isEmpty((CharSequence)this.mLastTwo) ? "" : "ending in \u2022\u2022" + this.mLastTwo;
        this.mDefault = false;
        this.mAuthenticationInsight = AuthenticationInsight.fromJson(payload.optJSONObject(AUTHENTICATION_INSIGHT_KEY));
        this.mExpirationMonth = Json.optString((JSONObject)creditCard, (String)EXPIRATION_MONTH_KEY, (String)"");
        this.mExpirationYear = Json.optString((JSONObject)creditCard, (String)EXPIRATION_YEAR_KEY, (String)"");
        this.mCardholderName = Json.optString((JSONObject)creditCard, (String)CARDHOLDER_NAME_KEY, (String)"");
    }

    @Override
    public String getTypeLabel() {
        return this.mCardType;
    }

    public String getCardType() {
        return this.mCardType;
    }

    public String getLastTwo() {
        return this.mLastTwo;
    }

    public String getLastFour() {
        return this.mLastFour;
    }

    public String getExpirationMonth() {
        return this.mExpirationMonth;
    }

    public String getExpirationYear() {
        return this.mExpirationYear;
    }

    public String getCardholderName() {
        return this.mCardholderName;
    }

    public ThreeDSecureInfo getThreeDSecureInfo() {
        return this.mThreeDSecureInfo;
    }

    public String getBin() {
        return this.mBin;
    }

    public BinData getBinData() {
        return this.mBinData;
    }

    public AuthenticationInsight getAuthenticationInsight() {
        return this.mAuthenticationInsight;
    }

    public CardNonce() {
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mCardType);
        dest.writeString(this.mLastTwo);
        dest.writeString(this.mLastFour);
        dest.writeParcelable((Parcelable)this.mBinData, flags);
        dest.writeParcelable((Parcelable)this.mThreeDSecureInfo, flags);
        dest.writeParcelable((Parcelable)this.mAuthenticationInsight, flags);
        dest.writeString(this.mExpirationMonth);
        dest.writeString(this.mExpirationYear);
        dest.writeString(this.mCardholderName);
    }

    protected CardNonce(Parcel in) {
        super(in);
        this.mCardType = in.readString();
        this.mLastTwo = in.readString();
        this.mLastFour = in.readString();
        this.mBinData = (BinData)in.readParcelable(BinData.class.getClassLoader());
        this.mThreeDSecureInfo = (ThreeDSecureInfo)in.readParcelable(ThreeDSecureInfo.class.getClassLoader());
        this.mAuthenticationInsight = (AuthenticationInsight)in.readParcelable(AuthenticationInsight.class.getClassLoader());
        this.mExpirationMonth = in.readString();
        this.mExpirationYear = in.readString();
        this.mCardholderName = in.readString();
    }
}

