/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.braintreepayments.api.Json;
import org.json.JSONException;
import org.json.JSONObject;

public class AmericanExpressRewardsBalance
implements Parcelable {
    private static final String ERROR_KEY = "error";
    private static final String ERROR_CODE_KEY = "code";
    private static final String ERROR_MESSAGE_KEY = "message";
    private static final String CONVERSION_RATE_KEY = "conversionRate";
    private static final String CURRENCY_AMOUNT_KEY = "currencyAmount";
    private static final String CURRENCY_ISO_CODE_KEY = "currencyIsoCode";
    private static final String REQUEST_ID_KEY = "requestId";
    private static final String REWARDS_AMOUNT_KEY = "rewardsAmount";
    private static final String REWARDS_UNIT_KEY = "rewardsUnit";
    private String mErrorCode;
    private String mErrorMessage;
    private String mConversionRate;
    private String mCurrencyAmount;
    private String mCurrencyIsoCode;
    private String mRequestId;
    private String mRewardsAmount;
    private String mRewardsUnit;
    public static final Parcelable.Creator<AmericanExpressRewardsBalance> CREATOR = new Parcelable.Creator<AmericanExpressRewardsBalance>(){

        public AmericanExpressRewardsBalance createFromParcel(Parcel source) {
            return new AmericanExpressRewardsBalance(source);
        }

        public AmericanExpressRewardsBalance[] newArray(int size) {
            return new AmericanExpressRewardsBalance[size];
        }
    };

    public static AmericanExpressRewardsBalance fromJson(String jsonString) throws JSONException {
        JSONObject json = new JSONObject(jsonString);
        AmericanExpressRewardsBalance rewardsBalance = new AmericanExpressRewardsBalance();
        if (json.has(ERROR_KEY)) {
            JSONObject errorJson = json.getJSONObject(ERROR_KEY);
            rewardsBalance.mErrorMessage = errorJson.getString(ERROR_MESSAGE_KEY);
            rewardsBalance.mErrorCode = errorJson.getString(ERROR_CODE_KEY);
        }
        rewardsBalance.mConversionRate = Json.optString((JSONObject)json, (String)CONVERSION_RATE_KEY, null);
        rewardsBalance.mCurrencyAmount = Json.optString((JSONObject)json, (String)CURRENCY_AMOUNT_KEY, null);
        rewardsBalance.mCurrencyIsoCode = Json.optString((JSONObject)json, (String)CURRENCY_ISO_CODE_KEY, null);
        rewardsBalance.mRequestId = Json.optString((JSONObject)json, (String)REQUEST_ID_KEY, null);
        rewardsBalance.mRewardsAmount = Json.optString((JSONObject)json, (String)REWARDS_AMOUNT_KEY, null);
        rewardsBalance.mRewardsUnit = Json.optString((JSONObject)json, (String)REWARDS_UNIT_KEY, null);
        return rewardsBalance;
    }

    @Nullable
    public String getErrorCode() {
        return this.mErrorCode;
    }

    @Nullable
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    @Nullable
    public String getConversionRate() {
        return this.mConversionRate;
    }

    @Nullable
    public String getCurrencyAmount() {
        return this.mCurrencyAmount;
    }

    @Nullable
    public String getCurrencyIsoCode() {
        return this.mCurrencyIsoCode;
    }

    @Nullable
    public String getRequestId() {
        return this.mRequestId;
    }

    @Nullable
    public String getRewardsAmount() {
        return this.mRewardsAmount;
    }

    @Nullable
    public String getRewardsUnit() {
        return this.mRewardsUnit;
    }

    public AmericanExpressRewardsBalance() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mErrorCode);
        dest.writeString(this.mErrorMessage);
        dest.writeString(this.mConversionRate);
        dest.writeString(this.mCurrencyAmount);
        dest.writeString(this.mCurrencyIsoCode);
        dest.writeString(this.mRequestId);
        dest.writeString(this.mRewardsAmount);
        dest.writeString(this.mRewardsUnit);
    }

    private AmericanExpressRewardsBalance(Parcel in) {
        this.mErrorCode = in.readString();
        this.mErrorMessage = in.readString();
        this.mConversionRate = in.readString();
        this.mCurrencyAmount = in.readString();
        this.mCurrencyIsoCode = in.readString();
        this.mRequestId = in.readString();
        this.mRewardsAmount = in.readString();
        this.mRewardsUnit = in.readString();
    }
}

