/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.internal;

import android.text.TextUtils;
import com.braintreepayments.api.exceptions.BraintreeApiErrorResponse;
import com.braintreepayments.api.exceptions.UnprocessableEntityException;
import com.braintreepayments.api.internal.BraintreeApiCertificate;
import com.braintreepayments.api.internal.HttpClient;
import com.braintreepayments.api.internal.TLSSocketFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;

public class BraintreeApiHttpClient
extends HttpClient {
    public static final String API_VERSION_2016_10_07 = "2016-10-07";
    private final String mBearer;
    private final String mApiVersion;

    public BraintreeApiHttpClient(String baseUrl, String bearer) {
        this(baseUrl, bearer, API_VERSION_2016_10_07);
    }

    public BraintreeApiHttpClient(String baseUrl, String bearer, String apiVersion) {
        this.mBaseUrl = baseUrl;
        this.mBearer = bearer;
        this.mApiVersion = apiVersion;
        this.setUserAgent("braintree/android/3.14.0");
        try {
            this.setSSLSocketFactory((SSLSocketFactory)new TLSSocketFactory(BraintreeApiCertificate.getCertInputStream()));
        }
        catch (SSLException e) {
            this.setSSLSocketFactory(null);
        }
    }

    protected HttpURLConnection init(String url) throws IOException {
        HttpURLConnection connection = super.init(url);
        if (!TextUtils.isEmpty((CharSequence)this.mBearer)) {
            connection.setRequestProperty("Authorization", "Bearer " + this.mBearer);
        }
        connection.setRequestProperty("Braintree-Version", this.mApiVersion);
        return connection;
    }

    protected String parseResponse(HttpURLConnection connection) throws Exception {
        try {
            return super.parseResponse(connection);
        }
        catch (UnprocessableEntityException e) {
            throw new BraintreeApiErrorResponse(e.getMessage());
        }
    }
}

