/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.braintreepayments.api.Venmo;
import com.braintreepayments.api.internal.ClassHelper;
import com.paypal.android.sdk.onetouch.core.PayPalOneTouchCore;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsEvent {
    private static final String SESSION_ID_KEY = "sessionId";
    private static final String DEVICE_NETWORK_TYPE_KEY = "deviceNetworkType";
    private static final String USER_INTERFACE_ORIENTATION_KEY = "userInterfaceOrientation";
    private static final String MERCHANT_APP_VERSION_KEY = "merchantAppVersion";
    private static final String PAYPAL_INSTALLED_KEY = "paypalInstalled";
    private static final String VENMO_INSTALLED_KEY = "venmoInstalled";
    private static final String INTEGRATION_TYPE_KEY = "integrationType";
    private static final String DROP_IN_VERSION_KEY = "dropinVersion";
    int id;
    String event;
    long timestamp;
    JSONObject metadata = new JSONObject();

    public AnalyticsEvent() {
    }

    public AnalyticsEvent(Context context, String sessionId, String integration, String event) {
        this.event = "android." + event;
        this.timestamp = System.currentTimeMillis();
        try {
            this.metadata.put(SESSION_ID_KEY, (Object)sessionId).put(INTEGRATION_TYPE_KEY, (Object)integration).put(DEVICE_NETWORK_TYPE_KEY, (Object)this.getNetworkType(context)).put(USER_INTERFACE_ORIENTATION_KEY, (Object)this.getUserOrientation(context)).put(MERCHANT_APP_VERSION_KEY, (Object)this.getAppVersion(context)).put(PAYPAL_INSTALLED_KEY, this.isPayPalInstalled(context)).put(VENMO_INSTALLED_KEY, Venmo.isVenmoInstalled(context)).put(DROP_IN_VERSION_KEY, (Object)AnalyticsEvent.getDropInVersion());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private String getNetworkType(Context context) {
        String networkType = null;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            networkType = networkInfo.getTypeName();
        }
        if (networkType == null) {
            networkType = "none";
        }
        return networkType;
    }

    private String getUserOrientation(Context context) {
        int orientation = context.getResources().getConfiguration().orientation;
        switch (orientation) {
            case 1: {
                return "Portrait";
            }
            case 2: {
                return "Landscape";
            }
        }
        return "Unknown";
    }

    private String getAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            return "VersionUnknown";
        }
    }

    private boolean isPayPalInstalled(Context context) {
        try {
            Class.forName(PayPalOneTouchCore.class.getName());
            return PayPalOneTouchCore.isWalletAppInstalled((Context)context);
        }
        catch (ClassNotFoundException | NoClassDefFoundError ignored) {
            return false;
        }
    }

    private static String getDropInVersion() {
        return (String)ClassHelper.getFieldValue((String)"com.braintreepayments.api.dropin.BuildConfig", (String)"VERSION_NAME");
    }
}

