/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api.exceptions;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.braintreepayments.api.Json;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BraintreeApiError
implements Parcelable {
    private String mCode;
    private String mMessage;
    private String mIn;
    private String mAt;
    public static final Parcelable.Creator<BraintreeApiError> CREATOR = new Parcelable.Creator<BraintreeApiError>(){

        public BraintreeApiError createFromParcel(Parcel source) {
            return new BraintreeApiError(source);
        }

        public BraintreeApiError[] newArray(int size) {
            return new BraintreeApiError[size];
        }
    };

    public static List<BraintreeApiError> fromJsonArray(JSONArray json) {
        if (json == null) {
            json = new JSONArray();
        }
        ArrayList<BraintreeApiError> errors = new ArrayList<BraintreeApiError>();
        for (int i = 0; i < json.length(); ++i) {
            try {
                errors.add(BraintreeApiError.fromJson(json.getJSONObject(i)));
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return errors;
    }

    public static BraintreeApiError fromJson(JSONObject json) {
        BraintreeApiError error = new BraintreeApiError();
        error.mCode = Json.optString((JSONObject)json, (String)"code", null);
        error.mMessage = Json.optString((JSONObject)json, (String)"developer_message", null);
        error.mIn = Json.optString((JSONObject)json, (String)"in", null);
        error.mAt = Json.optString((JSONObject)json, (String)"at", null);
        return error;
    }

    @Nullable
    public String getCode() {
        return this.mCode;
    }

    @Nullable
    public String getMessage() {
        return this.mMessage;
    }

    @Nullable
    public String getIn() {
        return this.mIn;
    }

    @Nullable
    public String getAt() {
        return this.mAt;
    }

    public String toString() {
        return "BraintreeApiError " + this.mCode + " for " + this.mIn + ": " + this.mMessage;
    }

    public BraintreeApiError() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mCode);
        dest.writeString(this.mMessage);
        dest.writeString(this.mIn);
        dest.writeString(this.mAt);
    }

    protected BraintreeApiError(Parcel in) {
        this.mCode = in.readString();
        this.mMessage = in.readString();
        this.mIn = in.readString();
        this.mAt = in.readString();
    }
}

