/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.TokenizationClient;
import com.braintreepayments.api.exceptions.AppSwitchNotAvailableException;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.PaymentMethodNonceCallback;
import com.braintreepayments.api.internal.AppHelper;
import com.braintreepayments.api.internal.BraintreeSharedPreferences;
import com.braintreepayments.api.internal.SignatureVerification;
import com.braintreepayments.api.models.ClientToken;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.MetadataBuilder;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.braintreepayments.api.models.VenmoAccountBuilder;
import com.braintreepayments.api.models.VenmoAccountNonce;
import com.braintreepayments.api.models.VenmoConfiguration;
import org.json.JSONException;
import org.json.JSONObject;

public class Venmo {
    private static final String VAULT_VENMO_KEY = "com.braintreepayments.api.Venmo.VAULT_VENMO_KEY";
    private static final String META_KEY = "_meta";
    static final String EXTRA_MERCHANT_ID = "com.braintreepayments.api.MERCHANT_ID";
    static final String EXTRA_ACCESS_TOKEN = "com.braintreepayments.api.ACCESS_TOKEN";
    static final String EXTRA_ENVIRONMENT = "com.braintreepayments.api.ENVIRONMENT";
    static final String EXTRA_BRAINTREE_DATA = "com.braintreepayments.api.EXTRA_BRAINTREE_DATA";
    static final String EXTRA_PAYMENT_METHOD_NONCE = "com.braintreepayments.api.EXTRA_PAYMENT_METHOD_NONCE";
    static final String EXTRA_USERNAME = "com.braintreepayments.api.EXTRA_USER_NAME";
    static final String PACKAGE_NAME = "com.venmo";
    static final String APP_SWITCH_ACTIVITY = "controller.SetupMerchantActivity";
    static final String CERTIFICATE_SUBJECT = "CN=Andrew Kortina,OU=Engineering,O=Venmo,L=Philadelphia,ST=PA,C=US";
    static final String CERTIFICATE_ISSUER = "CN=Andrew Kortina,OU=Engineering,O=Venmo,L=Philadelphia,ST=PA,C=US";
    static final int PUBLIC_KEY_HASH_CODE = -129711843;

    public static boolean isVenmoInstalled(Context context) {
        return AppHelper.isIntentAvailable((Context)context, (Intent)Venmo.getVenmoIntent()) && SignatureVerification.isSignatureValid((Context)context, (String)PACKAGE_NAME, (String)"CN=Andrew Kortina,OU=Engineering,O=Venmo,L=Philadelphia,ST=PA,C=US", (String)"CN=Andrew Kortina,OU=Engineering,O=Venmo,L=Philadelphia,ST=PA,C=US", (int)-129711843);
    }

    public static void openVenmoAppPageInGooglePlay(BraintreeFragment fragment) {
        fragment.sendAnalyticsEvent("android.pay-with-venmo.app-store.invoked");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)"https://play.google.com/store/apps/details?id=com.venmo"));
        fragment.startActivity(intent);
    }

    private static Intent getVenmoIntent() {
        return new Intent().setComponent(new ComponentName(PACKAGE_NAME, "com.venmo.controller.SetupMerchantActivity"));
    }

    static Intent getLaunchIntent(VenmoConfiguration venmoConfiguration, String profileId, BraintreeFragment fragment) {
        Intent venmoIntent = Venmo.getVenmoIntent().putExtra(EXTRA_MERCHANT_ID, profileId).putExtra(EXTRA_ACCESS_TOKEN, venmoConfiguration.getAccessToken()).putExtra(EXTRA_ENVIRONMENT, venmoConfiguration.getEnvironment());
        try {
            JSONObject braintreeData = new JSONObject();
            JSONObject meta = new MetadataBuilder().sessionId(fragment.getSessionId()).integration(fragment.getIntegrationType()).version().build();
            braintreeData.put(META_KEY, (Object)meta);
            venmoIntent.putExtra(EXTRA_BRAINTREE_DATA, braintreeData.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return venmoIntent;
    }

    public static void authorizeAccount(final BraintreeFragment fragment, final boolean vault, final String profileId) {
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                fragment.sendAnalyticsEvent("pay-with-venmo.selected");
                String venmoProfileId = profileId;
                if (TextUtils.isEmpty((CharSequence)venmoProfileId)) {
                    venmoProfileId = configuration.getPayWithVenmo().getMerchantId();
                }
                String exceptionMessage = "";
                if (!configuration.getPayWithVenmo().isAccessTokenValid()) {
                    exceptionMessage = "Venmo is not enabled";
                } else if (!Venmo.isVenmoInstalled(fragment.getApplicationContext())) {
                    exceptionMessage = "Venmo is not installed";
                }
                if (!TextUtils.isEmpty((CharSequence)exceptionMessage)) {
                    fragment.postCallback(new AppSwitchNotAvailableException(exceptionMessage));
                    fragment.sendAnalyticsEvent("pay-with-venmo.app-switch.failed");
                } else {
                    Venmo.persistVenmoVaultOption(vault && fragment.getAuthorization() instanceof ClientToken, fragment.getApplicationContext());
                    fragment.startActivityForResult(Venmo.getLaunchIntent(configuration.getPayWithVenmo(), venmoProfileId, fragment), 13488);
                    fragment.sendAnalyticsEvent("pay-with-venmo.app-switch.started");
                }
            }
        });
    }

    public static void authorizeAccount(BraintreeFragment fragment, boolean vault) {
        Venmo.authorizeAccount(fragment, vault, null);
    }

    public static void authorizeAccount(BraintreeFragment fragment) {
        Venmo.authorizeAccount(fragment, false, null);
    }

    private static void persistVenmoVaultOption(boolean shouldVault, Context context) {
        BraintreeSharedPreferences.getSharedPreferences((Context)context).edit().putBoolean(VAULT_VENMO_KEY, shouldVault).apply();
    }

    private static boolean shouldVault(Context context) {
        return BraintreeSharedPreferences.getSharedPreferences((Context)context).getBoolean(VAULT_VENMO_KEY, false);
    }

    static void onActivityResult(BraintreeFragment fragment, int resultCode, Intent data) {
        if (resultCode == -1) {
            fragment.sendAnalyticsEvent("pay-with-venmo.app-switch.success");
            String nonce = data.getStringExtra(EXTRA_PAYMENT_METHOD_NONCE);
            if (Venmo.shouldVault(fragment.getApplicationContext()) && fragment.getAuthorization() instanceof ClientToken) {
                Venmo.vault(fragment, nonce);
            } else {
                String venmoUsername = data.getStringExtra(EXTRA_USERNAME);
                VenmoAccountNonce venmoAccountNonce = new VenmoAccountNonce(nonce, venmoUsername, venmoUsername);
                fragment.postCallback(venmoAccountNonce);
            }
        } else if (resultCode == 0) {
            fragment.sendAnalyticsEvent("pay-with-venmo.app-switch.canceled");
        }
    }

    private static void vault(final BraintreeFragment fragment, String nonce) {
        VenmoAccountBuilder vaultBuilder = new VenmoAccountBuilder().nonce(nonce);
        TokenizationClient.tokenize(fragment, vaultBuilder, new PaymentMethodNonceCallback(){

            @Override
            public void success(PaymentMethodNonce paymentMethodNonce) {
                fragment.postCallback(paymentMethodNonce);
                fragment.sendAnalyticsEvent("pay-with-venmo.vault.success");
            }

            @Override
            public void failure(Exception exception) {
                fragment.postCallback(exception);
                fragment.sendAnalyticsEvent("pay-with-venmo.vault.failed");
            }
        });
    }
}

