/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.interfaces.BraintreeResponseListener;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.internal.UUIDHelper;
import com.braintreepayments.api.models.ClientToken;
import com.braintreepayments.api.models.Configuration;
import com.braintreepayments.api.models.PaymentMethodNonce;
import com.kount.api.DataCollector;
import com.paypal.android.sdk.data.collector.InstallationIdentifier;
import com.paypal.android.sdk.data.collector.PayPalDataCollector;
import com.paypal.android.sdk.data.collector.PayPalDataCollectorRequest;
import com.paypal.android.sdk.onetouch.core.PayPalOneTouchCore;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class DataCollector {
    private static final String DEVICE_SESSION_ID_KEY = "device_session_id";
    private static final String FRAUD_MERCHANT_ID_KEY = "fraud_merchant_id";
    private static final String CORRELATION_ID_KEY = "correlation_id";

    public static void collectDeviceData(BraintreeFragment fragment, BraintreeResponseListener<String> listener) {
        DataCollector.collectDeviceData(fragment, null, listener);
    }

    public static void collectDeviceData(final BraintreeFragment fragment, final String merchantId, final BraintreeResponseListener<String> listener) {
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                final JSONObject deviceData = new JSONObject();
                try {
                    String clientMetadataId = DataCollector.getPayPalClientMetadataId(fragment.getApplicationContext());
                    if (!TextUtils.isEmpty((CharSequence)clientMetadataId)) {
                        deviceData.put(DataCollector.CORRELATION_ID_KEY, (Object)clientMetadataId);
                    }
                }
                catch (JSONException clientMetadataId) {
                    // empty catch block
                }
                if (configuration.getKount().isEnabled()) {
                    final String id = merchantId != null ? merchantId : configuration.getKount().getKountMerchantId();
                    try {
                        final String deviceSessionId = UUIDHelper.getFormattedUUID();
                        DataCollector.startDeviceCollector(fragment, id, deviceSessionId, new BraintreeResponseListener<String>(){

                            @Override
                            public void onResponse(String sessionId) {
                                try {
                                    deviceData.put(DataCollector.DEVICE_SESSION_ID_KEY, (Object)deviceSessionId);
                                    deviceData.put(DataCollector.FRAUD_MERCHANT_ID_KEY, (Object)id);
                                }
                                catch (JSONException jSONException) {
                                    // empty catch block
                                }
                                listener.onResponse(deviceData.toString());
                            }
                        });
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError | NumberFormatException ignored) {
                        listener.onResponse(deviceData.toString());
                    }
                } else {
                    listener.onResponse(deviceData.toString());
                }
            }
        });
    }

    public static void collectPayPalDeviceData(BraintreeFragment fragment, BraintreeResponseListener<String> listener) {
        JSONObject deviceData = new JSONObject();
        try {
            String clientMetadataId = DataCollector.getPayPalClientMetadataId(fragment.getApplicationContext());
            if (!TextUtils.isEmpty((CharSequence)clientMetadataId)) {
                deviceData.put(CORRELATION_ID_KEY, (Object)clientMetadataId);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        listener.onResponse(deviceData.toString());
    }

    public static String getPayPalClientMetadataId(Context context) {
        try {
            return PayPalOneTouchCore.getClientMetadataId((Context)context);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            try {
                return PayPalDataCollector.getClientMetadataId((Context)context);
            }
            catch (NoClassDefFoundError noClassDefFoundError2) {
                return "";
            }
        }
    }

    private static void startDeviceCollector(final BraintreeFragment fragment, final String merchantId, final String deviceSessionId, final @Nullable BraintreeResponseListener<String> listener) throws ClassNotFoundException, NumberFormatException {
        fragment.sendAnalyticsEvent("data-collector.kount.started");
        Class.forName(com.kount.api.DataCollector.class.getName());
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                com.kount.api.DataCollector dataCollector = com.kount.api.DataCollector.getInstance();
                dataCollector.setContext(fragment.getApplicationContext());
                dataCollector.setMerchantID(Integer.parseInt(merchantId));
                dataCollector.setLocationCollectorConfig(DataCollector.LocationConfig.COLLECT);
                dataCollector.setEnvironment(DataCollector.getDeviceCollectorEnvironment(configuration.getEnvironment()));
                dataCollector.collectForSession(deviceSessionId, new DataCollector.CompletionHandler(){

                    public void completed(String sessionID) {
                        fragment.sendAnalyticsEvent("data-collector.kount.succeeded");
                        if (listener != null) {
                            listener.onResponse(sessionID);
                        }
                    }

                    public void failed(String sessionID, DataCollector.Error error) {
                        fragment.sendAnalyticsEvent("data-collector.kount.failed");
                        if (listener != null) {
                            listener.onResponse(sessionID);
                        }
                    }
                });
            }
        });
    }

    static void collectRiskData(final BraintreeFragment fragment, final @NonNull PaymentMethodNonce paymentMethodNonce) {
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                if (configuration.getCardConfiguration().isFraudDataCollectionEnabled()) {
                    String customerId;
                    HashMap<String, String> additionalProperties = new HashMap<String, String>();
                    additionalProperties.put("rda_tenant", "bt_card");
                    additionalProperties.put("mid", configuration.getMerchantId());
                    if (fragment.getAuthorization() instanceof ClientToken && (customerId = ((ClientToken)fragment.getAuthorization()).getCustomerId()) != null) {
                        additionalProperties.put("cid", customerId);
                    }
                    PayPalDataCollectorRequest request = new PayPalDataCollectorRequest().setApplicationGuid(InstallationIdentifier.getInstallationGUID((Context)fragment.getApplicationContext())).setClientMetadataId(paymentMethodNonce.getNonce()).setDisableBeacon(true).setAdditionalData(additionalProperties);
                    PayPalDataCollector.getClientMetadataId((Context)fragment.getApplicationContext(), (PayPalDataCollectorRequest)request);
                }
            }
        });
    }

    @VisibleForTesting
    static int getDeviceCollectorEnvironment(String environment) {
        if ("production".equalsIgnoreCase(environment)) {
            return 2;
        }
        return 1;
    }
}

