/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.net.Uri;
import com.braintreepayments.api.BraintreeFragment;
import com.braintreepayments.api.TokenizationClient;
import com.braintreepayments.api.interfaces.ConfigurationListener;
import com.braintreepayments.api.interfaces.HttpResponseCallback;
import com.braintreepayments.api.models.AmericanExpressRewardsBalance;
import com.braintreepayments.api.models.Configuration;
import org.json.JSONException;

public class AmericanExpress {
    private static final String AMEX_REWARDS_BALANCE_PATH = TokenizationClient.versionedPath("payment_methods/amex_rewards_balance");

    public static void getRewardsBalance(final BraintreeFragment fragment, final String nonce, final String currencyIsoCode) {
        fragment.waitForConfiguration(new ConfigurationListener(){

            @Override
            public void onConfigurationFetched(Configuration configuration) {
                String getRewardsBalanceUrl = Uri.parse((String)AMEX_REWARDS_BALANCE_PATH).buildUpon().appendQueryParameter("paymentMethodNonce", nonce).appendQueryParameter("currencyIsoCode", currencyIsoCode).build().toString();
                fragment.sendAnalyticsEvent("amex.rewards-balance.start");
                fragment.getHttpClient().get(getRewardsBalanceUrl, new HttpResponseCallback(){

                    public void success(String responseBody) {
                        fragment.sendAnalyticsEvent("amex.rewards-balance.success");
                        try {
                            fragment.postAmericanExpressCallback(AmericanExpressRewardsBalance.fromJson(responseBody));
                        }
                        catch (JSONException e) {
                            fragment.sendAnalyticsEvent("amex.rewards-balance.parse.failed");
                            fragment.postCallback((Exception)((Object)e));
                        }
                    }

                    public void failure(Exception exception) {
                        fragment.postCallback(exception);
                        fragment.sendAnalyticsEvent("amex.rewards-balance.error");
                    }
                });
            }
        });
    }
}

