/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import com.braintreepayments.api.CardConfiguration;
import com.braintreepayments.api.Json;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u00c6\u0003J-\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00112\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/braintreepayments/api/VisaCheckoutConfiguration;", "", "json", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "apiKey", "", "externalClientId", "acceptedCardBrands", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getAcceptedCardBrands", "()Ljava/util/List;", "getApiKey", "()Ljava/lang/String;", "getExternalClientId", "isEnabled", "", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "BraintreeCore_release"})
public final class VisaCheckoutConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String apiKey;
    @NotNull
    private final String externalClientId;
    @NotNull
    private final List<String> acceptedCardBrands;
    private final boolean isEnabled;
    @NotNull
    private static final String API_KEY = "apikey";
    @NotNull
    private static final String EXTERNAL_CLIENT_ID = "externalClientId";

    public VisaCheckoutConfiguration(@NotNull String apiKey, @NotNull String externalClientId, @NotNull List<String> acceptedCardBrands) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)externalClientId, (String)EXTERNAL_CLIENT_ID);
        Intrinsics.checkNotNullParameter(acceptedCardBrands, (String)"acceptedCardBrands");
        this.apiKey = apiKey;
        this.externalClientId = externalClientId;
        this.acceptedCardBrands = acceptedCardBrands;
        this.isEnabled = !Intrinsics.areEqual((Object)this.apiKey, (Object)"");
    }

    @NotNull
    public final String getApiKey() {
        return this.apiKey;
    }

    @NotNull
    public final String getExternalClientId() {
        return this.externalClientId;
    }

    @NotNull
    public final List<String> getAcceptedCardBrands() {
        return this.acceptedCardBrands;
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public VisaCheckoutConfiguration(@Nullable JSONObject json) {
        String string = Json.optString((JSONObject)json, (String)API_KEY, (String)"");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optString(json, API_KEY, \"\")");
        String string2 = Json.optString((JSONObject)json, (String)EXTERNAL_CLIENT_ID, (String)"");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"optString(json, EXTERNAL_CLIENT_ID, \"\")");
        this(string, string2, VisaCheckoutConfiguration.Companion.supportedCardTypesToAcceptedCardBrands(new CardConfiguration(json).getSupportedCardTypes()));
    }

    @NotNull
    public final String component1() {
        return this.apiKey;
    }

    @NotNull
    public final String component2() {
        return this.externalClientId;
    }

    @NotNull
    public final List<String> component3() {
        return this.acceptedCardBrands;
    }

    @NotNull
    public final VisaCheckoutConfiguration copy(@NotNull String apiKey, @NotNull String externalClientId, @NotNull List<String> acceptedCardBrands) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)externalClientId, (String)EXTERNAL_CLIENT_ID);
        Intrinsics.checkNotNullParameter(acceptedCardBrands, (String)"acceptedCardBrands");
        return new VisaCheckoutConfiguration(apiKey, externalClientId, acceptedCardBrands);
    }

    public static /* synthetic */ VisaCheckoutConfiguration copy$default(VisaCheckoutConfiguration visaCheckoutConfiguration, String string, String string2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = visaCheckoutConfiguration.apiKey;
        }
        if ((n & 2) != 0) {
            string2 = visaCheckoutConfiguration.externalClientId;
        }
        if ((n & 4) != 0) {
            list = visaCheckoutConfiguration.acceptedCardBrands;
        }
        return visaCheckoutConfiguration.copy(string, string2, list);
    }

    @NotNull
    public String toString() {
        return "VisaCheckoutConfiguration(apiKey=" + this.apiKey + ", externalClientId=" + this.externalClientId + ", acceptedCardBrands=" + this.acceptedCardBrands + ')';
    }

    public int hashCode() {
        int result = this.apiKey.hashCode();
        result = result * 31 + this.externalClientId.hashCode();
        result = result * 31 + ((Object)this.acceptedCardBrands).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VisaCheckoutConfiguration)) {
            return false;
        }
        VisaCheckoutConfiguration visaCheckoutConfiguration = (VisaCheckoutConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.apiKey, (Object)visaCheckoutConfiguration.apiKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.externalClientId, (Object)visaCheckoutConfiguration.externalClientId)) {
            return false;
        }
        return Intrinsics.areEqual(this.acceptedCardBrands, visaCheckoutConfiguration.acceptedCardBrands);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/braintreepayments/api/VisaCheckoutConfiguration$Companion;", "", "()V", "API_KEY", "", "EXTERNAL_CLIENT_ID", "supportedCardTypesToAcceptedCardBrands", "", "supportedCardTypes", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> supportedCardTypesToAcceptedCardBrands(List<String> supportedCardTypes) {
            List acceptedCardBrands = new ArrayList();
            for (String supportedCardType : supportedCardTypes) {
                String string;
                Intrinsics.checkNotNullExpressionValue((Object)supportedCardType.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                int n = -1;
                switch (string.hashCode()) {
                    case 273184745: {
                        if (string.equals("discover")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1120637072: {
                        if (string.equals("american express")) {
                            n = 2;
                        }
                        break;
                    }
                    case 3619905: {
                        if (string.equals("visa")) {
                            n = 3;
                        }
                        break;
                    }
                    case -2038717326: {
                        if (string.equals("mastercard")) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 3: {
                        acceptedCardBrands.add("VISA");
                        break;
                    }
                    case 4: {
                        acceptedCardBrands.add("MASTERCARD");
                        break;
                    }
                    case 1: {
                        acceptedCardBrands.add("DISCOVER");
                        break;
                    }
                    case 2: {
                        acceptedCardBrands.add("AMEX");
                    }
                }
            }
            return acceptedCardBrands;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

