/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.text.TextUtils;
import com.braintreepayments.api.Json;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/braintreepayments/api/VenmoConfiguration;", "", "json", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "accessToken", "", "environment", "merchantId", "enrichedCustomerDataEnabled", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getAccessToken", "()Ljava/lang/String;", "getEnrichedCustomerDataEnabled", "()Z", "getEnvironment", "isAccessTokenValid", "getMerchantId", "Companion", "BraintreeCore_release"})
public final class VenmoConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String accessToken;
    @NotNull
    private final String environment;
    @NotNull
    private final String merchantId;
    private final boolean enrichedCustomerDataEnabled;
    private final boolean isAccessTokenValid;
    @NotNull
    private static final String ACCESS_TOKEN_KEY = "accessToken";
    @NotNull
    private static final String ENVIRONMENT_KEY = "environment";
    @NotNull
    private static final String MERCHANT_ID_KEY = "merchantId";
    @NotNull
    private static final String ECD_ENABLED_KEY = "enrichedCustomerDataEnabled";

    public VenmoConfiguration(@NotNull String accessToken, @NotNull String environment, @NotNull String merchantId, boolean enrichedCustomerDataEnabled) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)ACCESS_TOKEN_KEY);
        Intrinsics.checkNotNullParameter((Object)environment, (String)ENVIRONMENT_KEY);
        Intrinsics.checkNotNullParameter((Object)merchantId, (String)MERCHANT_ID_KEY);
        this.accessToken = accessToken;
        this.environment = environment;
        this.merchantId = merchantId;
        this.enrichedCustomerDataEnabled = enrichedCustomerDataEnabled;
        this.isAccessTokenValid = !TextUtils.isEmpty((CharSequence)this.accessToken);
    }

    @NotNull
    public final String getAccessToken() {
        return this.accessToken;
    }

    @NotNull
    public final String getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final String getMerchantId() {
        return this.merchantId;
    }

    public final boolean getEnrichedCustomerDataEnabled() {
        return this.enrichedCustomerDataEnabled;
    }

    public VenmoConfiguration(@Nullable JSONObject json) {
        String string = Json.optString((JSONObject)json, (String)ACCESS_TOKEN_KEY, (String)"");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optString(json, ACCESS_TOKEN_KEY, \"\")");
        String string2 = Json.optString((JSONObject)json, (String)ENVIRONMENT_KEY, (String)"");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"optString(json, ENVIRONMENT_KEY, \"\")");
        String string3 = Json.optString((JSONObject)json, (String)MERCHANT_ID_KEY, (String)"");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"optString(json, MERCHANT_ID_KEY, \"\")");
        Boolean bl = Json.optBoolean((JSONObject)json, (String)ECD_ENABLED_KEY, (Boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"optBoolean(json, ECD_ENABLED_KEY, false)");
        this(string, string2, string3, bl);
    }

    public final boolean isAccessTokenValid() {
        return this.isAccessTokenValid;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/braintreepayments/api/VenmoConfiguration$Companion;", "", "()V", "ACCESS_TOKEN_KEY", "", "ECD_ENABLED_KEY", "ENVIRONMENT_KEY", "MERCHANT_ID_KEY", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

