/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.BraintreeSharedPreferences;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\u000eR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/braintreepayments/api/UUIDHelper;", "", "()V", "formattedUUID", "", "getFormattedUUID", "()Ljava/lang/String;", "getInstallationGUID", "context", "Landroid/content/Context;", "braintreeSharedPreferences", "Lcom/braintreepayments/api/BraintreeSharedPreferences;", "getInstallationGUID$BraintreeCore_release", "getPersistentUUID", "getPersistentUUID$BraintreeCore_release", "Companion", "BraintreeCore_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class UUIDHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String BRAINTREE_UUID_KEY = "braintreeUUID";
    @NotNull
    private static final String INSTALL_GUID = "InstallationGUID";

    @Nullable
    public final String getPersistentUUID(@Nullable Context context) {
        BraintreeSharedPreferences braintreeSharedPreferences = BraintreeSharedPreferences.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)braintreeSharedPreferences, (String)"getInstance(context)");
        return this.getPersistentUUID$BraintreeCore_release(braintreeSharedPreferences);
    }

    @VisibleForTesting
    @Nullable
    public final String getPersistentUUID$BraintreeCore_release(@NotNull BraintreeSharedPreferences braintreeSharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)braintreeSharedPreferences, (String)"braintreeSharedPreferences");
        String uuid = braintreeSharedPreferences.getString(BRAINTREE_UUID_KEY, null);
        if (uuid == null) {
            uuid = this.getFormattedUUID();
            braintreeSharedPreferences.putString(BRAINTREE_UUID_KEY, uuid);
        }
        return uuid;
    }

    @NotNull
    public final String getFormattedUUID() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return StringsKt.replace$default((String)string, (String)"-", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public final String getInstallationGUID(@Nullable Context context) {
        BraintreeSharedPreferences braintreeSharedPreferences = BraintreeSharedPreferences.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)braintreeSharedPreferences, (String)"getInstance(context)");
        return this.getInstallationGUID$BraintreeCore_release(braintreeSharedPreferences);
    }

    @VisibleForTesting
    @NotNull
    public final String getInstallationGUID$BraintreeCore_release(@NotNull BraintreeSharedPreferences braintreeSharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)braintreeSharedPreferences, (String)"braintreeSharedPreferences");
        String installationGUID = braintreeSharedPreferences.getString(INSTALL_GUID, null);
        if (installationGUID == null) {
            installationGUID = UUID.randomUUID().toString();
            braintreeSharedPreferences.putString(INSTALL_GUID, installationGUID);
        }
        String string = installationGUID;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"installationGUID");
        return string;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/braintreepayments/api/UUIDHelper$Companion;", "", "()V", "BRAINTREE_UUID_KEY", "", "INSTALL_GUID", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

