/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import androidx.annotation.RestrictTo;
import com.braintreepayments.api.Authorization;
import com.braintreepayments.api.InvalidArgumentException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/braintreepayments/api/TokenizationKey;", "Lcom/braintreepayments/api/Authorization;", "tokenizationKey", "", "(Ljava/lang/String;)V", "bearer", "getBearer", "()Ljava/lang/String;", "configUrl", "getConfigUrl", "environment", "getEnvironment", "merchantId", "getMerchantId", "url", "getUrl", "Companion", "BraintreeCore_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class TokenizationKey
extends Authorization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String configUrl;
    @NotNull
    private final String bearer;
    @NotNull
    private final String environment;
    @NotNull
    private final String merchantId;
    @NotNull
    private final String url;
    @NotNull
    public static final String MATCHER = "^[a-zA-Z0-9]+_[a-zA-Z0-9]+_[a-zA-Z0-9_]+$";
    @NotNull
    private static final String DEVELOPMENT_URL = "http://10.0.2.2:3000/";
    @NotNull
    private static final String SANDBOX_URL = "https://api.sandbox.braintreegateway.com/";
    @NotNull
    private static final String PRODUCTION_URL = "https://api.braintreegateway.com/";
    @NotNull
    private static final String CONFIG_V1 = "v1/configuration";

    public TokenizationKey(@NotNull String tokenizationKey) {
        Intrinsics.checkNotNullParameter((Object)tokenizationKey, (String)"tokenizationKey");
        super(tokenizationKey);
        this.bearer = this.toString();
        String[] stringArray = new String[]{"_"};
        List tokenizationKeyParts = StringsKt.split$default((CharSequence)tokenizationKey, (String[])stringArray, (boolean)false, (int)3, (int)2, null);
        this.environment = (String)tokenizationKeyParts.get(0);
        this.merchantId = (String)tokenizationKeyParts.get(2);
        this.url = TokenizationKey.Companion.getUrl(this.environment) + "merchants/" + this.merchantId + "/client_api/";
        this.configUrl = this.url + CONFIG_V1;
    }

    @Override
    @NotNull
    public String getConfigUrl() {
        return this.configUrl;
    }

    @Override
    @NotNull
    public String getBearer() {
        return this.bearer;
    }

    @NotNull
    public final String getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final String getMerchantId() {
        return this.merchantId;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/braintreepayments/api/TokenizationKey$Companion;", "", "()V", "CONFIG_V1", "", "DEVELOPMENT_URL", "MATCHER", "PRODUCTION_URL", "SANDBOX_URL", "getUrl", "environment", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String getUrl(String environment) throws InvalidArgumentException {
            String string;
            switch (environment) {
                case "development": {
                    string = TokenizationKey.DEVELOPMENT_URL;
                    break;
                }
                case "sandbox": {
                    string = TokenizationKey.SANDBOX_URL;
                    break;
                }
                case "production": {
                    string = TokenizationKey.PRODUCTION_URL;
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Tokenization Key contained invalid environment");
                }
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

