/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.text.TextUtils;
import com.braintreepayments.api.Json;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u00c2\u0003J#\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0006J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/braintreepayments/api/GraphQLConfiguration;", "", "json", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;)V", "url", "", "features", "", "(Ljava/lang/String;Ljava/util/Set;)V", "isEnabled", "", "()Z", "getUrl", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "isFeatureEnabled", "feature", "toString", "Companion", "BraintreeCore_release"})
public final class GraphQLConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final Set<String> features;
    private final boolean isEnabled;

    public GraphQLConfiguration(@NotNull String url, @NotNull Set<String> features) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        this.url = url;
        this.features = features;
        this.isEnabled = !TextUtils.isEmpty((CharSequence)this.url);
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public GraphQLConfiguration(@Nullable JSONObject json) {
        String string = Json.optString((JSONObject)json, (String)"url", (String)"");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optString(json, GraphQLConstants.Keys.URL, \"\")");
        JSONObject jSONObject = json;
        this(string, GraphQLConfiguration.Companion.parseJsonFeatures((JSONArray)(jSONObject != null ? jSONObject.optJSONArray("features") : null)));
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final boolean isFeatureEnabled(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return this.isEnabled && this.features.contains(feature);
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    private final Set<String> component2() {
        return this.features;
    }

    @NotNull
    public final GraphQLConfiguration copy(@NotNull String url, @NotNull Set<String> features) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(features, (String)"features");
        return new GraphQLConfiguration(url, features);
    }

    public static /* synthetic */ GraphQLConfiguration copy$default(GraphQLConfiguration graphQLConfiguration, String string, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            string = graphQLConfiguration.url;
        }
        if ((n & 2) != 0) {
            set = graphQLConfiguration.features;
        }
        return graphQLConfiguration.copy(string, set);
    }

    @NotNull
    public String toString() {
        return "GraphQLConfiguration(url=" + this.url + ", features=" + this.features + ')';
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = result * 31 + ((Object)this.features).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GraphQLConfiguration)) {
            return false;
        }
        GraphQLConfiguration graphQLConfiguration = (GraphQLConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.url, (Object)graphQLConfiguration.url)) {
            return false;
        }
        return Intrinsics.areEqual(this.features, graphQLConfiguration.features);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/braintreepayments/api/GraphQLConfiguration$Companion;", "", "()V", "parseJsonFeatures", "", "", "jsonArray", "Lorg/json/JSONArray;", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<String> parseJsonFeatures(JSONArray jsonArray) {
            Set features;
            block1: {
                JSONArray jSONArray;
                features = new HashSet();
                JSONArray jSONArray2 = jsonArray;
                if (jSONArray2 == null) break block1;
                JSONArray array = jSONArray = jSONArray2;
                boolean bl = false;
                int n = array.length();
                for (int i = 0; i < n; ++i) {
                    String string = array.optString(i, "");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"array.optString(i, \"\")");
                    features.add(string);
                }
            }
            return features;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

