/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import com.braintreepayments.api.BraintreeError;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 )2\u00060\u0001j\u0002`\u00022\u00020\u0003:\u0001)B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0014\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010 \u001a\u00020\u0006H\u0016J\u0010\u0010!\u001a\u0004\u0018\u00010\u00142\u0006\u0010\"\u001a\u00020\bJ\u0012\u0010#\u001a\u00020$2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010%\u001a\u00020\bH\u0016J\u0018\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0006H\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R4\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006*"}, d2={"Lcom/braintreepayments/api/ErrorWithResponse;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Landroid/os/Parcelable;", "()V", "statusCode", "", "jsonString", "", "(ILjava/lang/String;)V", "inParcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "_message", "_originalResponse", "errorResponse", "getErrorResponse", "()Ljava/lang/String;", "<set-?>", "", "Lcom/braintreepayments/api/BraintreeError;", "fieldErrors", "getFieldErrors", "()Ljava/util/List;", "setFieldErrors$BraintreeCore_release", "(Ljava/util/List;)V", "message", "getMessage", "getStatusCode", "()I", "setStatusCode$BraintreeCore_release", "(I)V", "describeContents", "errorFor", "field", "parseJson", "", "toString", "writeToParcel", "dest", "flags", "Companion", "BraintreeCore_release"})
public class ErrorWithResponse
extends Exception
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int statusCode;
    @Nullable
    private String _message;
    @Nullable
    private String _originalResponse;
    @Nullable
    private List<? extends BraintreeError> fieldErrors;
    @NotNull
    private static final String ERROR_KEY = "error";
    @NotNull
    private static final String MESSAGE_KEY = "message";
    @NotNull
    private static final String FIELD_ERRORS_KEY = "fieldErrors";
    private static final int GRAPHQL_ERROR_CODE = 422;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<ErrorWithResponse> CREATOR = (Parcelable.Creator)new Parcelable.Creator<ErrorWithResponse>(){

        @NotNull
        public ErrorWithResponse createFromParcel(@NotNull Parcel source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new ErrorWithResponse(source);
        }

        @NotNull
        public ErrorWithResponse[] newArray(int size) {
            return new ErrorWithResponse[size];
        }
    };

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode$BraintreeCore_release(int n) {
        this.statusCode = n;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this._message;
    }

    @Nullable
    public String getErrorResponse() {
        return this._originalResponse;
    }

    @Nullable
    public List<BraintreeError> getFieldErrors() {
        return this.fieldErrors;
    }

    public void setFieldErrors$BraintreeCore_release(@Nullable List<? extends BraintreeError> list) {
        this.fieldErrors = list;
    }

    private ErrorWithResponse() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ErrorWithResponse(int statusCode, @Nullable String jsonString) {
        this.setStatusCode$BraintreeCore_release(statusCode);
        this._originalResponse = jsonString;
        try {
            this.parseJson(jsonString);
        }
        catch (JSONException e) {
            this._message = "Parsing error response failed";
            this.setFieldErrors$BraintreeCore_release(new ArrayList());
        }
    }

    private final void parseJson(String jsonString) throws JSONException {
        block0: {
            String string = jsonString;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            JSONObject json = new JSONObject(it);
            boolean bl2 = false;
            this._message = json.getJSONObject(ERROR_KEY).getString(MESSAGE_KEY);
            this.setFieldErrors$BraintreeCore_release(BraintreeError.Companion.fromJsonArray$BraintreeCore_release(json.optJSONArray(FIELD_ERRORS_KEY)));
        }
    }

    @Nullable
    public final BraintreeError errorFor(@NotNull String field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (this.getFieldErrors() == null) {
            return null;
        }
        List<BraintreeError> list = this.getFieldErrors();
        Intrinsics.checkNotNull(list);
        for (BraintreeError error : list) {
            BraintreeError returnError;
            if (Intrinsics.areEqual((Object)error.getField(), (Object)field)) {
                return error;
            }
            if (error.getFieldErrors() == null || (returnError = error.errorFor(field)) == null) continue;
            return returnError;
        }
        return null;
    }

    @Override
    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n            ErrorWithResponse (" + this.getStatusCode() + "): " + this.getMessage() + "\n            " + this.getFieldErrors() + "\n        "));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeInt(this.getStatusCode());
        dest.writeString(this.getMessage());
        dest.writeString(this._originalResponse);
        dest.writeTypedList(this.getFieldErrors());
    }

    protected ErrorWithResponse(@NotNull Parcel inParcel) {
        Intrinsics.checkNotNullParameter((Object)inParcel, (String)"inParcel");
        this.setStatusCode$BraintreeCore_release(inParcel.readInt());
        this._message = inParcel.readString();
        this._originalResponse = inParcel.readString();
        this.setFieldErrors$BraintreeCore_release(inParcel.createTypedArrayList(BraintreeError.CREATOR));
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final ErrorWithResponse fromJson(@Nullable String json) throws JSONException {
        return Companion.fromJson(json);
    }

    public /* synthetic */ ErrorWithResponse(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u000eJ\u0012\u0010\u000f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/braintreepayments/api/ErrorWithResponse$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/braintreepayments/api/ErrorWithResponse;", "ERROR_KEY", "", "FIELD_ERRORS_KEY", "GRAPHQL_ERROR_CODE", "", "MESSAGE_KEY", "fromGraphQLJson", "json", "fromGraphQLJson$BraintreeCore_release", "fromJson", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final ErrorWithResponse fromJson(@Nullable String json) throws JSONException {
            ErrorWithResponse errorWithResponse;
            ErrorWithResponse $this$fromJson_u24lambda_u2d0 = errorWithResponse = new ErrorWithResponse(null);
            boolean bl = false;
            $this$fromJson_u24lambda_u2d0._originalResponse = json;
            $this$fromJson_u24lambda_u2d0.parseJson(json);
            return errorWithResponse;
        }

        @NotNull
        public final ErrorWithResponse fromGraphQLJson$BraintreeCore_release(@Nullable String json) {
            ErrorWithResponse errorWithResponse;
            ErrorWithResponse $this$fromGraphQLJson_u24lambda_u2d1 = errorWithResponse = new ErrorWithResponse(null);
            boolean bl = false;
            $this$fromGraphQLJson_u24lambda_u2d1._originalResponse = json;
            $this$fromGraphQLJson_u24lambda_u2d1.setStatusCode$BraintreeCore_release(422);
            ErrorWithResponse errorWithResponse2 = errorWithResponse;
            try {
                boolean fieldErrorsEmpty;
                JSONArray jSONArray;
                String string = json;
                if (string != null) {
                    String it = string;
                    boolean bl2 = false;
                    jSONArray = new JSONObject(it).getJSONArray("errors");
                } else {
                    jSONArray = null;
                }
                JSONArray errors = jSONArray;
                errorWithResponse2.setFieldErrors$BraintreeCore_release(BraintreeError.Companion.fromGraphQLJsonArray(errors));
                List<BraintreeError> list = errorWithResponse2.getFieldErrors();
                boolean bl3 = fieldErrorsEmpty = list != null ? list.isEmpty() : true;
                if (fieldErrorsEmpty) {
                    JSONArray jSONArray2 = errors;
                    errorWithResponse2._message = jSONArray2 != null && (jSONArray2 = jSONArray2.getJSONObject(0)) != null ? jSONArray2.getString(ErrorWithResponse.MESSAGE_KEY) : null;
                } else {
                    errorWithResponse2._message = "Input is invalid.";
                }
            }
            catch (JSONException e) {
                ErrorWithResponse errorWithResponse3;
                ErrorWithResponse $this$fromGraphQLJson_u24lambda_u2d3 = errorWithResponse3 = errorWithResponse2;
                boolean bl4 = false;
                $this$fromGraphQLJson_u24lambda_u2d3._message = "Parsing error response failed";
                $this$fromGraphQLJson_u24lambda_u2d3.setFieldErrors$BraintreeCore_release(new ArrayList());
            }
            return errorWithResponse2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

