/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.AppHelper;
import com.braintreepayments.api.Configuration;
import com.braintreepayments.api.DeviceMetadata;
import com.braintreepayments.api.SignatureVerifier;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\tH\u0002J\u0012\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J5\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b\u001cJ\u0014\u0010\u001d\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u001f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0010\u0010 \u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/braintreepayments/api/DeviceInspector;", "", "()V", "appHelper", "Lcom/braintreepayments/api/AppHelper;", "signatureVerifier", "Lcom/braintreepayments/api/SignatureVerifier;", "(Lcom/braintreepayments/api/AppHelper;Lcom/braintreepayments/api/SignatureVerifier;)V", "dropInVersion", "", "getDropInVersion", "()Ljava/lang/String;", "isDeviceEmulator", "", "()Z", "getAPIVersion", "getAppName", "context", "Landroid/content/Context;", "getAppVersion", "getApplicationInfo", "Landroid/content/pm/ApplicationInfo;", "getDeviceMetadata", "Lcom/braintreepayments/api/DeviceMetadata;", "configuration", "Lcom/braintreepayments/api/Configuration;", "sessionId", "integration", "getDeviceMetadata$BraintreeCore_release", "getPackageInfo", "isPayPalInstalled", "isVenmoAppSwitchAvailable", "isVenmoInstalled", "Companion", "BraintreeCore_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class DeviceInspector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AppHelper appHelper;
    @NotNull
    private final SignatureVerifier signatureVerifier;
    @NotNull
    private static final String PAYPAL_APP_PACKAGE = "com.paypal.android.p2pmobile";
    @NotNull
    private static final String VENMO_APP_PACKAGE = "com.venmo";
    @NotNull
    private static final String VENMO_APP_SWITCH_ACTIVITY = "controller.SetupMerchantActivity";
    @NotNull
    public static final String VENMO_BASE_64_ENCODED_SIGNATURE = "x34mMawEUcCG8l95riWCOK+kAJYejVmdt44l6tzcyUc=\n";

    @VisibleForTesting
    public DeviceInspector(@NotNull AppHelper appHelper, @NotNull SignatureVerifier signatureVerifier) {
        Intrinsics.checkNotNullParameter((Object)appHelper, (String)"appHelper");
        Intrinsics.checkNotNullParameter((Object)signatureVerifier, (String)"signatureVerifier");
        this.appHelper = appHelper;
        this.signatureVerifier = signatureVerifier;
    }

    public DeviceInspector() {
        this(new AppHelper(), new SignatureVerifier());
    }

    @NotNull
    public final DeviceMetadata getDeviceMetadata$BraintreeCore_release(@Nullable Context context, @Nullable Configuration configuration, @Nullable String sessionId, @Nullable String integration) {
        Context context2 = context;
        Configuration configuration2 = configuration;
        Configuration configuration3 = configuration;
        return new DeviceMetadata(context2 != null ? context2.getPackageName() : null, this.getAppName(context), "4.45.1", this.getAPIVersion(), "braintreeclientsdk", Build.MANUFACTURER, Build.MODEL, this.getDropInVersion(), configuration2 != null ? configuration2.getEnvironment() : null, "mobile-native", integration, this.isDeviceEmulator(), this.getAppVersion(context), configuration3 != null ? configuration3.getMerchantId() : null, "Android", sessionId);
    }

    public final boolean isVenmoAppSwitchAvailable(@Nullable Context context) {
        boolean isVenmoIntentAvailable = this.appHelper.isIntentAvailable(context, DeviceInspector.Companion.getVenmoIntent());
        boolean isVenmoSignatureValid = this.signatureVerifier.isSignatureValid(context, VENMO_APP_PACKAGE, VENMO_BASE_64_ENCODED_SIGNATURE);
        return isVenmoIntentAvailable && isVenmoSignatureValid;
    }

    public final boolean isPayPalInstalled(@Nullable Context context) {
        return this.appHelper.isAppInstalled(context, PAYPAL_APP_PACKAGE);
    }

    public final boolean isVenmoInstalled(@Nullable Context context) {
        return this.appHelper.isAppInstalled(context, VENMO_APP_PACKAGE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDeviceEmulator() {
        if (StringsKt.equals((String)"google_sdk", (String)Build.PRODUCT, (boolean)true)) return true;
        if (StringsKt.equals((String)"sdk", (String)Build.PRODUCT, (boolean)true)) return true;
        if (StringsKt.equals((String)"Genymotion", (String)Build.MANUFACTURER, (boolean)true)) return true;
        String string = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FINGERPRINT");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"generic", (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final String getAppName(Context context) {
        Object object;
        block3: {
            block2: {
                object = this.getApplicationInfo(context);
                if (object == null) break block2;
                ApplicationInfo appInfo = object;
                boolean bl = false;
                Context context2 = context;
                String string = String.valueOf(context2 != null && (context2 = context2.getPackageManager()) != null ? context2.getApplicationLabel(appInfo) : null);
                object = string;
                if (string != null) break block3;
            }
            object = "ApplicationNameUnknown";
        }
        return object;
    }

    private final ApplicationInfo getApplicationInfo(Context context) {
        ApplicationInfo applicationInfo;
        try {
            Context context2 = context;
            applicationInfo = context2 != null && (context2 = context2.getPackageManager()) != null ? context2.getApplicationInfo(context.getPackageName(), 0) : null;
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
        }
        return applicationInfo;
    }

    private final String getAppVersion(Context context) {
        String string = this.getPackageInfo(context);
        if (string == null) {
            string = "VersionUnknown";
        }
        return string;
    }

    private final String getPackageInfo(Context context) {
        String string;
        Context context2 = context;
        if (context2 != null) {
            String string2;
            Context it = context2;
            boolean bl = false;
            try {
                PackageInfo packageInfo;
                PackageInfo packageInfo2 = packageInfo = it.getPackageManager().getPackageInfo(it.getPackageName(), 0);
                string2 = packageInfo2 != null ? packageInfo2.versionName : null;
            }
            catch (PackageManager.NameNotFoundException ignored) {
                string2 = null;
            }
            string = string2;
        } else {
            string = null;
        }
        return string;
    }

    private final String getAPIVersion() {
        int sdkInt = Build.VERSION.SDK_INT;
        return "Android API " + sdkInt;
    }

    private final String getDropInVersion() {
        return Companion.getDropInVersion$BraintreeCore_release();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/braintreepayments/api/DeviceInspector$Companion;", "", "()V", "PAYPAL_APP_PACKAGE", "", "VENMO_APP_PACKAGE", "VENMO_APP_SWITCH_ACTIVITY", "VENMO_BASE_64_ENCODED_SIGNATURE", "getVENMO_BASE_64_ENCODED_SIGNATURE$annotations", "venmoIntent", "Landroid/content/Intent;", "getVenmoIntent", "()Landroid/content/Intent;", "getDropInVersion", "getDropInVersion$BraintreeCore_release", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getVENMO_BASE_64_ENCODED_SIGNATURE$annotations() {
        }

        private final Intent getVenmoIntent() {
            Intent intent = new Intent().setComponent(new ComponentName(DeviceInspector.VENMO_APP_PACKAGE, "com.venmo.controller.SetupMerchantActivity"));
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent().setComponent(\n \u2026          )\n            )");
            return intent;
        }

        @Nullable
        public final String getDropInVersion$BraintreeCore_release() {
            try {
                Class<?> dropInBuildConfigClass = Class.forName("com.braintreepayments.api.dropin.BuildConfig");
                Field versionNameField = dropInBuildConfigClass.getField("VERSION_NAME");
                versionNameField.setAccessible(true);
                return (String)versionNameField.get(Reflection.getOrCreateKotlinClass(String.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

