/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.BraintreeClient;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\b\u0007\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0001H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\u0006\u0010\u0014\u001a\u00020\u000eJ\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/braintreepayments/api/CrashReporter;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "braintreeClient", "Lcom/braintreepayments/api/BraintreeClient;", "(Lcom/braintreepayments/api/BraintreeClient;)V", "braintreeClientRef", "Ljava/lang/ref/WeakReference;", "(Ljava/lang/ref/WeakReference;)V", "defaultExceptionHandler", "determineExceptionCause", "", "ex", "", "handleExceptionWithDefaultBehavior", "", "thread", "Ljava/lang/Thread;", "registerExceptionHandler", "handler", "restoreDefaultExceptionHandler", "start", "uncaughtException", "exception", "Cause", "Companion", "BraintreeCore_release"})
public final class CrashReporter
implements Thread.UncaughtExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WeakReference<BraintreeClient> braintreeClientRef;
    @Nullable
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;
    public static final int CAUSE_UNKNOWN = 0;
    public static final int CAUSE_RELATED_TO_PAYPAL = 1;
    public static final int CAUSE_RELATED_TO_BRAINTREE = 2;

    @VisibleForTesting
    public CrashReporter(@NotNull WeakReference<BraintreeClient> braintreeClientRef) {
        Intrinsics.checkNotNullParameter(braintreeClientRef, (String)"braintreeClientRef");
        this.braintreeClientRef = braintreeClientRef;
    }

    public CrashReporter(@NotNull BraintreeClient braintreeClient) {
        Intrinsics.checkNotNullParameter((Object)braintreeClient, (String)"braintreeClient");
        this(new WeakReference<BraintreeClient>(braintreeClient));
    }

    private final void registerExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.defaultExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }

    private final void restoreDefaultExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this.defaultExceptionHandler);
        this.defaultExceptionHandler = null;
    }

    private final int determineExceptionCause(Throwable ex) {
        int n;
        StringWriter stringWriter = new StringWriter();
        ex.printStackTrace(new PrintWriter(stringWriter));
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringWriter.toString()");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"com.braintreepayments", (boolean)false, (int)2, null)) {
            n = 2;
        } else {
            String string2 = stringWriter.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stringWriter.toString()");
            n = StringsKt.contains$default((CharSequence)string2, (CharSequence)"com.paypal", (boolean)false, (int)2, null) ? 1 : 0;
        }
        return n;
    }

    private final void handleExceptionWithDefaultBehavior(Thread thread, Throwable ex) {
        block0: {
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.defaultExceptionHandler;
            if (uncaughtExceptionHandler == null) break block0;
            uncaughtExceptionHandler.uncaughtException(thread, ex);
        }
    }

    public final void start() {
        this.registerExceptionHandler(this);
    }

    @Override
    public void uncaughtException(@NotNull Thread thread, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        BraintreeClient braintreeClient = (BraintreeClient)this.braintreeClientRef.get();
        if (braintreeClient == null) {
            this.handleExceptionWithDefaultBehavior(thread, exception);
            this.restoreDefaultExceptionHandler();
            return;
        }
        int result = this.determineExceptionCause(exception);
        switch (result) {
            case 1: 
            case 2: {
                braintreeClient.reportCrash();
            }
        }
        this.handleExceptionWithDefaultBehavior(thread, exception);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0081\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/braintreepayments/api/CrashReporter$Cause;", "", "BraintreeCore_release"})
    public static @interface Cause {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/braintreepayments/api/CrashReporter$Companion;", "", "()V", "CAUSE_RELATED_TO_BRAINTREE", "", "CAUSE_RELATED_TO_PAYPAL", "CAUSE_UNKNOWN", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

