/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import android.net.Uri;
import android.util.Base64;
import com.braintreepayments.api.Authorization;
import com.braintreepayments.api.BraintreeException;
import com.braintreepayments.api.BraintreeHttpClient;
import com.braintreepayments.api.Configuration;
import com.braintreepayments.api.ConfigurationCache;
import com.braintreepayments.api.ConfigurationException;
import com.braintreepayments.api.ConfigurationLoaderCallback;
import com.braintreepayments.api.HttpResponseCallback;
import com.braintreepayments.api.InvalidAuthorization;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/braintreepayments/api/ConfigurationLoader;", "", "context", "Landroid/content/Context;", "httpClient", "Lcom/braintreepayments/api/BraintreeHttpClient;", "(Landroid/content/Context;Lcom/braintreepayments/api/BraintreeHttpClient;)V", "configurationCache", "Lcom/braintreepayments/api/ConfigurationCache;", "(Lcom/braintreepayments/api/BraintreeHttpClient;Lcom/braintreepayments/api/ConfigurationCache;)V", "getCachedConfiguration", "Lcom/braintreepayments/api/Configuration;", "authorization", "Lcom/braintreepayments/api/Authorization;", "configUrl", "", "loadConfiguration", "", "callback", "Lcom/braintreepayments/api/ConfigurationLoaderCallback;", "saveConfigurationToCache", "configuration", "Companion", "BraintreeCore_release"})
public final class ConfigurationLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BraintreeHttpClient httpClient;
    @NotNull
    private final ConfigurationCache configurationCache;

    public ConfigurationLoader(@NotNull BraintreeHttpClient httpClient, @NotNull ConfigurationCache configurationCache) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)configurationCache, (String)"configurationCache");
        this.httpClient = httpClient;
        this.configurationCache = configurationCache;
    }

    public ConfigurationLoader(@NotNull Context context, @NotNull BraintreeHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this(httpClient, ConfigurationCache.Companion.getInstance(context));
    }

    public final void loadConfiguration(@NotNull Authorization authorization, @NotNull ConfigurationLoaderCallback callback) {
        block3: {
            Unit unit;
            Configuration cachedConfig;
            Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            if (authorization instanceof InvalidAuthorization) {
                String message = ((InvalidAuthorization)authorization).getErrorMessage();
                callback.onResult(null, new BraintreeException(message, null, 2, null));
                return;
            }
            String string = Uri.parse((String)authorization.getConfigUrl()).buildUpon().appendQueryParameter("configVersion", "3").build().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parse(authorization.conf\u2026)\n            .toString()");
            String configUrl = string;
            Configuration configuration = cachedConfig = this.getCachedConfiguration(authorization, configUrl);
            if (configuration != null) {
                Configuration it = configuration;
                boolean bl = false;
                callback.onResult(cachedConfig, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block3;
            ConfigurationLoader $this$loadConfiguration_u24lambda_u2d1 = this;
            boolean bl = false;
            $this$loadConfiguration_u24lambda_u2d1.httpClient.get(configUrl, null, authorization, 1, new HttpResponseCallback($this$loadConfiguration_u24lambda_u2d1, authorization, configUrl, callback){
                final /* synthetic */ ConfigurationLoader $this_run;
                final /* synthetic */ Authorization $authorization;
                final /* synthetic */ String $configUrl;
                final /* synthetic */ ConfigurationLoaderCallback $callback;
                {
                    this.$this_run = $receiver;
                    this.$authorization = $authorization;
                    this.$configUrl = $configUrl;
                    this.$callback = $callback;
                }

                public void onResult(@Nullable String responseBody, @Nullable Exception httpError) {
                    block3: {
                        block2: {
                            String string = responseBody;
                            if (string == null) break block2;
                            String string2 = string;
                            ConfigurationLoader configurationLoader = this.$this_run;
                            Authorization authorization = this.$authorization;
                            String string3 = this.$configUrl;
                            ConfigurationLoaderCallback configurationLoaderCallback = this.$callback;
                            String it = string2;
                            boolean bl = false;
                            try {
                                Configuration configuration = Configuration.Companion.fromJson(it);
                                ConfigurationLoader.access$saveConfigurationToCache(configurationLoader, configuration, authorization, string3);
                                configurationLoaderCallback.onResult(configuration, null);
                            }
                            catch (JSONException jsonException) {
                                configurationLoaderCallback.onResult(null, (Exception)((Object)jsonException));
                            }
                            break block3;
                        }
                        Exception exception = httpError;
                        if (exception == null) break block3;
                        Exception exception2 = exception;
                        ConfigurationLoaderCallback configurationLoaderCallback = this.$callback;
                        Exception error = exception2;
                        boolean bl = false;
                        String errorMessageFormat = "Request for configuration has failed: %s";
                        Object[] objectArray = new Object[]{error.getMessage()};
                        String string = String.format(errorMessageFormat, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                        String errorMessage = string;
                        ConfigurationException configurationException = new ConfigurationException(errorMessage, error);
                        configurationLoaderCallback.onResult(null, configurationException);
                    }
                }
            });
        }
    }

    private final void saveConfigurationToCache(Configuration configuration, Authorization authorization, String configUrl) {
        String cacheKey = ConfigurationLoader.Companion.createCacheKey(authorization, configUrl);
        this.configurationCache.saveConfiguration(configuration, cacheKey);
    }

    private final Configuration getCachedConfiguration(Authorization authorization, String configUrl) {
        Configuration configuration;
        String cacheKey = ConfigurationLoader.Companion.createCacheKey(authorization, configUrl);
        String cachedConfigResponse = this.configurationCache.getConfiguration(cacheKey);
        try {
            configuration = Configuration.Companion.fromJson(cachedConfigResponse);
        }
        catch (JSONException e) {
            configuration = null;
        }
        return configuration;
    }

    public static final /* synthetic */ void access$saveConfigurationToCache(ConfigurationLoader $this, Configuration configuration, Authorization authorization, String configUrl) {
        $this.saveConfigurationToCache(configuration, authorization, configUrl);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"Lcom/braintreepayments/api/ConfigurationLoader$Companion;", "", "()V", "createCacheKey", "", "authorization", "Lcom/braintreepayments/api/Authorization;", "configUrl", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String createCacheKey(Authorization authorization, String configUrl) {
            String string = configUrl + authorization.getBearer();
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            String string2 = Base64.encodeToString((byte[])byArray, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(\"$configU\u2026earer}\".toByteArray(), 0)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

