/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.BraintreeSharedPreferences;
import com.braintreepayments.api.Configuration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/braintreepayments/api/ConfigurationCache;", "", "sharedPreferences", "Lcom/braintreepayments/api/BraintreeSharedPreferences;", "(Lcom/braintreepayments/api/BraintreeSharedPreferences;)V", "getConfiguration", "", "cacheKey", "currentTimeMillis", "", "saveConfiguration", "", "configuration", "Lcom/braintreepayments/api/Configuration;", "Companion", "BraintreeCore_release"})
public final class ConfigurationCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BraintreeSharedPreferences sharedPreferences;
    private static final long TIME_TO_LIVE = TimeUnit.MINUTES.toMillis(5L);
    @Nullable
    private static volatile ConfigurationCache INSTANCE;

    @VisibleForTesting
    public ConfigurationCache(@NotNull BraintreeSharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        this.sharedPreferences = sharedPreferences;
    }

    @Nullable
    public final String getConfiguration(@NotNull String cacheKey) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        return this.getConfiguration(cacheKey, System.currentTimeMillis());
    }

    @Nullable
    public final String getConfiguration(@NotNull String cacheKey, long currentTimeMillis) {
        long timeInCache;
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        String timestampKey = cacheKey + "_timestamp";
        if (this.sharedPreferences.containsKey(timestampKey) && (timeInCache = currentTimeMillis - this.sharedPreferences.getLong(timestampKey)) < TIME_TO_LIVE) {
            return this.sharedPreferences.getString(cacheKey, "");
        }
        return null;
    }

    public final void saveConfiguration(@NotNull Configuration configuration, @Nullable String cacheKey) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.saveConfiguration(configuration, cacheKey, System.currentTimeMillis());
    }

    public final void saveConfiguration(@NotNull Configuration configuration, @Nullable String cacheKey, long currentTimeMillis) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        String timestampKey = cacheKey + "_timestamp";
        this.sharedPreferences.putStringAndLong(cacheKey, configuration.toJson(), timestampKey, currentTimeMillis);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/braintreepayments/api/ConfigurationCache$Companion;", "", "()V", "INSTANCE", "Lcom/braintreepayments/api/ConfigurationCache;", "TIME_TO_LIVE", "", "getInstance", "context", "Landroid/content/Context;", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final ConfigurationCache getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ConfigurationCache configurationCache = INSTANCE;
            if (configurationCache == null) {
                Companion companion = this;
                synchronized (companion) {
                    boolean bl = false;
                    ConfigurationCache configurationCache2 = INSTANCE;
                    if (configurationCache2 == null) {
                        ConfigurationCache configurationCache3;
                        BraintreeSharedPreferences braintreeSharedPreferences = BraintreeSharedPreferences.getInstance((Context)context);
                        Intrinsics.checkNotNullExpressionValue((Object)braintreeSharedPreferences, (String)"getInstance(context)");
                        ConfigurationCache it = configurationCache3 = new ConfigurationCache(braintreeSharedPreferences);
                        boolean bl2 = false;
                        INSTANCE = it;
                        configurationCache2 = configurationCache3;
                    }
                    ConfigurationCache configurationCache4 = configurationCache2;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl20 : MonitorExitStatement: MONITOREXIT : var2_2
                    configurationCache = configurationCache4;
                }
            }
            return configurationCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

