/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import androidx.annotation.RestrictTo;
import com.braintreepayments.api.BraintreeApiConfiguration;
import com.braintreepayments.api.CardConfiguration;
import com.braintreepayments.api.GooglePayConfiguration;
import com.braintreepayments.api.GraphQLConfiguration;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.PayPalConfiguration;
import com.braintreepayments.api.SamsungPayConfiguration;
import com.braintreepayments.api.UnionPayConfiguration;
import com.braintreepayments.api.VenmoConfiguration;
import com.braintreepayments.api.VisaCheckoutConfiguration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 v2\u00020\u0001:\u0001vB\u0011\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010s\u001a\u00020+2\u0006\u0010t\u001a\u00020\u0003H\u0007J\b\u0010u\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0016\u0010 \u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0007R\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0007R\u0016\u0010*\u001a\u00020+8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010,R\u0014\u0010-\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010,R\u0016\u0010.\u001a\u00020+8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010,R\u0014\u0010/\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010,R\u0016\u00100\u001a\u00020+8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010,R\u0016\u00101\u001a\u00020+8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010,R\u0014\u00102\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010,R\u0014\u00103\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010,R\u0016\u00104\u001a\u00020+8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010,R\u0014\u00105\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010,R\u0014\u00106\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010,R\u0014\u00107\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010,R\u0014\u00108\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010,R\u0014\u00109\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010,R\u0014\u0010:\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010,R\u0016\u0010;\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u0007R\u0016\u0010=\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0007R\u0014\u0010?\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0007R\u0018\u0010A\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u0007R\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010E\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u0007R\u0016\u0010G\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u0007R\u0018\u0010I\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010\u0007R\u0018\u0010K\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\u0007R\u0016\u0010M\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010\u0007R\u0016\u0010O\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010\u0007R\u0016\u0010Q\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010\u0007R\u000e\u0010S\u001a\u00020TX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010U\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\u0007R\u0016\u0010W\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010\u0007R\u0016\u0010Y\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u0010\u0007R\u001c\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00030#8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\\\u0010%R\u001a\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00030#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010%R\u000e\u0010_\u001a\u00020`X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010a\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bb\u0010\u0007R\u000e\u0010c\u001a\u00020dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010e\u001a\u00020+8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010,R\u0016\u0010g\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010\u0007R\u0016\u0010i\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010\u0007R\u0016\u0010k\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010\u0007R\u000e\u0010m\u001a\u00020nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010o\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bp\u0010\u0007R\u001c\u0010q\u001a\b\u0012\u0004\u0012\u00020\u00030#8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010%\u00a8\u0006w"}, d2={"Lcom/braintreepayments/api/Configuration;", "", "configurationString", "", "(Ljava/lang/String;)V", "assetsUrl", "getAssetsUrl", "()Ljava/lang/String;", "braintreeApiAccessToken", "getBraintreeApiAccessToken", "braintreeApiConfiguration", "Lcom/braintreepayments/api/BraintreeApiConfiguration;", "braintreeApiUrl", "getBraintreeApiUrl", "cardConfiguration", "Lcom/braintreepayments/api/CardConfiguration;", "cardinalAuthenticationJwt", "getCardinalAuthenticationJwt", "challenges", "", "clientApiUrl", "getClientApiUrl", "environment", "getEnvironment", "googlePayAuthorizationFingerprint", "getGooglePayAuthorizationFingerprint", "googlePayConfiguration", "Lcom/braintreepayments/api/GooglePayConfiguration;", "googlePayDisplayName", "getGooglePayDisplayName", "googlePayEnvironment", "getGooglePayEnvironment", "googlePayPayPalClientId", "getGooglePayPayPalClientId", "googlePaySupportedNetworks", "", "getGooglePaySupportedNetworks", "()Ljava/util/List;", "graphQLConfiguration", "Lcom/braintreepayments/api/GraphQLConfiguration;", "graphQLUrl", "getGraphQLUrl", "isBraintreeApiEnabled", "", "()Z", "isCvvChallengePresent", "isFraudDataCollectionEnabled", "isGooglePayEnabled", "isGraphQLEnabled", "isKountEnabled", "isLocalPaymentEnabled", "isPayPalEnabled", "isPayPalTouchDisabled", "isPostalCodeChallengePresent", "isSamsungPayEnabled", "isThreeDSecureEnabled", "isUnionPayEnabled", "isVenmoEnabled", "isVisaCheckoutEnabled", "kountMerchantId", "getKountMerchantId", "merchantAccountId", "getMerchantAccountId", "merchantId", "getMerchantId", "payPalClientId", "getPayPalClientId", "payPalConfiguration", "Lcom/braintreepayments/api/PayPalConfiguration;", "payPalCurrencyIsoCode", "getPayPalCurrencyIsoCode", "payPalDirectBaseUrl", "getPayPalDirectBaseUrl", "payPalDisplayName", "getPayPalDisplayName", "payPalEnvironment", "getPayPalEnvironment", "payPalPrivacyUrl", "getPayPalPrivacyUrl", "payPalUserAgreementUrl", "getPayPalUserAgreementUrl", "samsungPayAuthorization", "getSamsungPayAuthorization", "samsungPayConfiguration", "Lcom/braintreepayments/api/SamsungPayConfiguration;", "samsungPayEnvironment", "getSamsungPayEnvironment", "samsungPayMerchantDisplayName", "getSamsungPayMerchantDisplayName", "samsungPayServiceId", "getSamsungPayServiceId", "samsungPaySupportedCardBrands", "getSamsungPaySupportedCardBrands", "supportedCardTypes", "getSupportedCardTypes", "unionPayConfiguration", "Lcom/braintreepayments/api/UnionPayConfiguration;", "venmoAccessToken", "getVenmoAccessToken", "venmoConfiguration", "Lcom/braintreepayments/api/VenmoConfiguration;", "venmoEnrichedCustomerDataEnabled", "getVenmoEnrichedCustomerDataEnabled", "venmoEnvironment", "getVenmoEnvironment", "venmoMerchantId", "getVenmoMerchantId", "visaCheckoutApiKey", "getVisaCheckoutApiKey", "visaCheckoutConfiguration", "Lcom/braintreepayments/api/VisaCheckoutConfiguration;", "visaCheckoutExternalClientId", "getVisaCheckoutExternalClientId", "visaCheckoutSupportedNetworks", "getVisaCheckoutSupportedNetworks", "isGraphQLFeatureEnabled", "feature", "toJson", "Companion", "BraintreeCore_release"})
public class Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String assetsUrl;
    @Nullable
    private final String cardinalAuthenticationJwt;
    @NotNull
    private final String clientApiUrl;
    @NotNull
    private final String environment;
    private final boolean isCvvChallengePresent;
    private final boolean isGooglePayEnabled;
    private final boolean isLocalPaymentEnabled;
    private final boolean isPayPalEnabled;
    private final boolean isPostalCodeChallengePresent;
    private final boolean isSamsungPayEnabled;
    private final boolean isThreeDSecureEnabled;
    private final boolean isUnionPayEnabled;
    private final boolean isVenmoEnabled;
    private final boolean isVisaCheckoutEnabled;
    @Nullable
    private final String merchantAccountId;
    @NotNull
    private final String merchantId;
    @Nullable
    private final String payPalDirectBaseUrl;
    @Nullable
    private final String payPalPrivacyUrl;
    @Nullable
    private final String payPalUserAgreementUrl;
    @NotNull
    private final List<String> supportedCardTypes;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String braintreeApiAccessToken;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String braintreeApiUrl;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    private final String googlePayAuthorizationFingerprint;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String googlePayDisplayName;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    private final String googlePayEnvironment;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String googlePayPayPalClientId;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final List<String> googlePaySupportedNetworks;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String graphQLUrl;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private final boolean isBraintreeApiEnabled;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private final boolean isFraudDataCollectionEnabled;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private final boolean isGraphQLEnabled;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private final boolean isKountEnabled;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private final boolean isPayPalTouchDisabled;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String kountMerchantId;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    private final String payPalClientId;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    private final String payPalCurrencyIsoCode;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    private final String payPalDisplayName;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    private final String payPalEnvironment;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String samsungPayAuthorization;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String samsungPayEnvironment;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String samsungPayMerchantDisplayName;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String samsungPayServiceId;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final List<String> samsungPaySupportedCardBrands;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String venmoAccessToken;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String venmoEnvironment;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String venmoMerchantId;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    private final boolean venmoEnrichedCustomerDataEnabled;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String visaCheckoutApiKey;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final String visaCheckoutExternalClientId;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    private final List<String> visaCheckoutSupportedNetworks;
    @NotNull
    private final BraintreeApiConfiguration braintreeApiConfiguration;
    @NotNull
    private final CardConfiguration cardConfiguration;
    @NotNull
    private final Set<String> challenges;
    @NotNull
    private final String configurationString;
    @NotNull
    private final GooglePayConfiguration googlePayConfiguration;
    @NotNull
    private final GraphQLConfiguration graphQLConfiguration;
    @NotNull
    private final PayPalConfiguration payPalConfiguration;
    @NotNull
    private final SamsungPayConfiguration samsungPayConfiguration;
    @NotNull
    private final UnionPayConfiguration unionPayConfiguration;
    @NotNull
    private final VenmoConfiguration venmoConfiguration;
    @NotNull
    private final VisaCheckoutConfiguration visaCheckoutConfiguration;
    @NotNull
    private static final String ASSETS_URL_KEY = "assetsUrl";
    @NotNull
    private static final String BRAINTREE_API_KEY = "braintreeApi";
    @NotNull
    private static final String CARDINAL_AUTHENTICATION_JWT = "cardinalAuthenticationJWT";
    @NotNull
    private static final String CARD_KEY = "creditCards";
    @NotNull
    private static final String CHALLENGES_KEY = "challenges";
    @NotNull
    private static final String CLIENT_API_URL_KEY = "clientApiUrl";
    @NotNull
    private static final String ENVIRONMENT_KEY = "environment";
    @NotNull
    private static final String GOOGLE_PAY_KEY = "androidPay";
    @NotNull
    private static final String GRAPHQL_KEY = "graphQL";
    @NotNull
    private static final String MERCHANT_ACCOUNT_ID_KEY = "merchantAccountId";
    @NotNull
    private static final String MERCHANT_ID_KEY = "merchantId";
    @NotNull
    private static final String PAYPAL_ENABLED_KEY = "paypalEnabled";
    @NotNull
    private static final String PAYPAL_KEY = "paypal";
    @NotNull
    private static final String PAY_WITH_VENMO_KEY = "payWithVenmo";
    @NotNull
    private static final String SAMSUNG_PAY_KEY = "samsungPay";
    @NotNull
    private static final String THREE_D_SECURE_ENABLED_KEY = "threeDSecureEnabled";
    @NotNull
    private static final String UNIONPAY_KEY = "unionPay";
    @NotNull
    private static final String VISA_CHECKOUT_KEY = "visaCheckout";

    public Configuration(@Nullable String configurationString) {
        if (configurationString == null) {
            throw new JSONException("Configuration cannot be null");
        }
        this.configurationString = configurationString;
        JSONObject json = new JSONObject(configurationString);
        String string = Json.optString((JSONObject)json, (String)ASSETS_URL_KEY, (String)"");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optString(json, ASSETS_URL_KEY, \"\")");
        this.assetsUrl = string;
        String string2 = json.getString(CLIENT_API_URL_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"json.getString(CLIENT_API_URL_KEY)");
        this.clientApiUrl = string2;
        this.challenges = new LinkedHashSet();
        JSONArray jSONArray = json.optJSONArray(CHALLENGES_KEY);
        if (jSONArray != null) {
            JSONArray challengesArray = jSONArray;
            boolean bl = false;
            int n = challengesArray.length();
            for (int i = 0; i < n; ++i) {
                String string3 = challengesArray.optString(i, "");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"challengesArray.optString(i, \"\")");
                this.challenges.add(string3);
            }
        }
        this.braintreeApiConfiguration = new BraintreeApiConfiguration(json.optJSONObject(BRAINTREE_API_KEY));
        this.cardConfiguration = new CardConfiguration(json.optJSONObject(CARD_KEY));
        this.cardinalAuthenticationJwt = Json.optString((JSONObject)json, (String)CARDINAL_AUTHENTICATION_JWT, null);
        String string4 = json.getString(ENVIRONMENT_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"json.getString(ENVIRONMENT_KEY)");
        this.environment = string4;
        this.googlePayConfiguration = new GooglePayConfiguration(json.optJSONObject(GOOGLE_PAY_KEY));
        this.graphQLConfiguration = new GraphQLConfiguration(json.optJSONObject(GRAPHQL_KEY));
        this.isPayPalEnabled = json.optBoolean(PAYPAL_ENABLED_KEY, false);
        this.isThreeDSecureEnabled = json.optBoolean(THREE_D_SECURE_ENABLED_KEY, false);
        this.merchantAccountId = Json.optString((JSONObject)json, (String)MERCHANT_ACCOUNT_ID_KEY, null);
        String string5 = json.getString(MERCHANT_ID_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"json.getString(MERCHANT_ID_KEY)");
        this.merchantId = string5;
        this.payPalConfiguration = new PayPalConfiguration(json.optJSONObject(PAYPAL_KEY));
        this.samsungPayConfiguration = new SamsungPayConfiguration(json.optJSONObject(SAMSUNG_PAY_KEY));
        this.unionPayConfiguration = new UnionPayConfiguration(json.optJSONObject(UNIONPAY_KEY));
        this.venmoConfiguration = new VenmoConfiguration(json.optJSONObject(PAY_WITH_VENMO_KEY));
        this.visaCheckoutConfiguration = new VisaCheckoutConfiguration(json.optJSONObject(VISA_CHECKOUT_KEY));
        this.isCvvChallengePresent = this.challenges.contains("cvv");
        this.isGooglePayEnabled = this.googlePayConfiguration.isEnabled();
        this.isLocalPaymentEnabled = this.isPayPalEnabled();
        this.isPostalCodeChallengePresent = this.challenges.contains("postal_code");
        this.isSamsungPayEnabled = this.samsungPayConfiguration.isEnabled();
        this.isUnionPayEnabled = this.unionPayConfiguration.isEnabled();
        this.isVenmoEnabled = this.venmoConfiguration.isAccessTokenValid();
        this.isVisaCheckoutEnabled = this.visaCheckoutConfiguration.isEnabled();
        this.payPalDirectBaseUrl = this.payPalConfiguration.getDirectBaseUrl();
        this.payPalPrivacyUrl = this.payPalConfiguration.getPrivacyUrl();
        this.payPalUserAgreementUrl = this.payPalConfiguration.getUserAgreementUrl();
        this.braintreeApiAccessToken = this.braintreeApiConfiguration.getAccessToken();
        this.braintreeApiUrl = this.braintreeApiConfiguration.getUrl();
        this.googlePayAuthorizationFingerprint = this.googlePayConfiguration.getGoogleAuthorizationFingerprint();
        this.googlePayDisplayName = this.googlePayConfiguration.getDisplayName();
        this.googlePayEnvironment = this.googlePayConfiguration.getEnvironment();
        this.googlePayPayPalClientId = this.googlePayConfiguration.getPaypalClientId();
        this.googlePaySupportedNetworks = this.googlePayConfiguration.getSupportedNetworks();
        this.graphQLUrl = this.graphQLConfiguration.getUrl();
        this.isBraintreeApiEnabled = this.braintreeApiConfiguration.isEnabled();
        this.isFraudDataCollectionEnabled = this.cardConfiguration.isFraudDataCollectionEnabled();
        this.isGraphQLEnabled = this.graphQLConfiguration.isEnabled();
        this.isKountEnabled = false;
        this.isPayPalTouchDisabled = this.payPalConfiguration.isTouchDisabled();
        this.kountMerchantId = "";
        this.payPalClientId = this.payPalConfiguration.getClientId();
        this.payPalCurrencyIsoCode = this.payPalConfiguration.getCurrencyIsoCode();
        this.payPalDisplayName = this.payPalConfiguration.getDisplayName();
        this.payPalEnvironment = this.payPalConfiguration.getEnvironment();
        this.samsungPayAuthorization = this.samsungPayConfiguration.getSamsungAuthorization();
        this.samsungPayEnvironment = this.samsungPayConfiguration.getEnvironment();
        this.samsungPayMerchantDisplayName = this.samsungPayConfiguration.getMerchantDisplayName();
        this.samsungPayServiceId = this.samsungPayConfiguration.getServiceId();
        this.samsungPaySupportedCardBrands = CollectionsKt.toList((Iterable)this.samsungPayConfiguration.getSupportedCardBrands());
        this.supportedCardTypes = this.cardConfiguration.getSupportedCardTypes();
        this.venmoAccessToken = this.venmoConfiguration.getAccessToken();
        this.venmoEnvironment = this.venmoConfiguration.getEnvironment();
        this.venmoMerchantId = this.venmoConfiguration.getMerchantId();
        this.venmoEnrichedCustomerDataEnabled = this.venmoConfiguration.getEnrichedCustomerDataEnabled();
        this.visaCheckoutApiKey = this.visaCheckoutConfiguration.getApiKey();
        this.visaCheckoutExternalClientId = this.visaCheckoutConfiguration.getExternalClientId();
        this.visaCheckoutSupportedNetworks = this.visaCheckoutConfiguration.getAcceptedCardBrands();
    }

    @NotNull
    public String getAssetsUrl() {
        return this.assetsUrl;
    }

    @Nullable
    public String getCardinalAuthenticationJwt() {
        return this.cardinalAuthenticationJwt;
    }

    @NotNull
    public String getClientApiUrl() {
        return this.clientApiUrl;
    }

    @NotNull
    public String getEnvironment() {
        return this.environment;
    }

    public boolean isCvvChallengePresent() {
        return this.isCvvChallengePresent;
    }

    public boolean isGooglePayEnabled() {
        return this.isGooglePayEnabled;
    }

    public boolean isLocalPaymentEnabled() {
        return this.isLocalPaymentEnabled;
    }

    public boolean isPayPalEnabled() {
        return this.isPayPalEnabled;
    }

    public boolean isPostalCodeChallengePresent() {
        return this.isPostalCodeChallengePresent;
    }

    public boolean isSamsungPayEnabled() {
        return this.isSamsungPayEnabled;
    }

    public boolean isThreeDSecureEnabled() {
        return this.isThreeDSecureEnabled;
    }

    public boolean isUnionPayEnabled() {
        return this.isUnionPayEnabled;
    }

    public boolean isVenmoEnabled() {
        return this.isVenmoEnabled;
    }

    public boolean isVisaCheckoutEnabled() {
        return this.isVisaCheckoutEnabled;
    }

    @Nullable
    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    @NotNull
    public String getMerchantId() {
        return this.merchantId;
    }

    @Nullable
    public String getPayPalDirectBaseUrl() {
        return this.payPalDirectBaseUrl;
    }

    @Nullable
    public String getPayPalPrivacyUrl() {
        return this.payPalPrivacyUrl;
    }

    @Nullable
    public String getPayPalUserAgreementUrl() {
        return this.payPalUserAgreementUrl;
    }

    @NotNull
    public List<String> getSupportedCardTypes() {
        return this.supportedCardTypes;
    }

    @NotNull
    public final String getBraintreeApiAccessToken() {
        return this.braintreeApiAccessToken;
    }

    @NotNull
    public final String getBraintreeApiUrl() {
        return this.braintreeApiUrl;
    }

    @Nullable
    public final String getGooglePayAuthorizationFingerprint() {
        return this.googlePayAuthorizationFingerprint;
    }

    @NotNull
    public final String getGooglePayDisplayName() {
        return this.googlePayDisplayName;
    }

    @Nullable
    public final String getGooglePayEnvironment() {
        return this.googlePayEnvironment;
    }

    @NotNull
    public final String getGooglePayPayPalClientId() {
        return this.googlePayPayPalClientId;
    }

    @NotNull
    public final List<String> getGooglePaySupportedNetworks() {
        return this.googlePaySupportedNetworks;
    }

    @NotNull
    public final String getGraphQLUrl() {
        return this.graphQLUrl;
    }

    public final boolean isBraintreeApiEnabled() {
        return this.isBraintreeApiEnabled;
    }

    public final boolean isFraudDataCollectionEnabled() {
        return this.isFraudDataCollectionEnabled;
    }

    public final boolean isGraphQLEnabled() {
        return this.isGraphQLEnabled;
    }

    public final boolean isKountEnabled() {
        return this.isKountEnabled;
    }

    public final boolean isPayPalTouchDisabled() {
        return this.isPayPalTouchDisabled;
    }

    @NotNull
    public final String getKountMerchantId() {
        return this.kountMerchantId;
    }

    @Nullable
    public final String getPayPalClientId() {
        return this.payPalClientId;
    }

    @Nullable
    public final String getPayPalCurrencyIsoCode() {
        return this.payPalCurrencyIsoCode;
    }

    @Nullable
    public final String getPayPalDisplayName() {
        return this.payPalDisplayName;
    }

    @Nullable
    public final String getPayPalEnvironment() {
        return this.payPalEnvironment;
    }

    @NotNull
    public final String getSamsungPayAuthorization() {
        return this.samsungPayAuthorization;
    }

    @NotNull
    public final String getSamsungPayEnvironment() {
        return this.samsungPayEnvironment;
    }

    @NotNull
    public final String getSamsungPayMerchantDisplayName() {
        return this.samsungPayMerchantDisplayName;
    }

    @NotNull
    public final String getSamsungPayServiceId() {
        return this.samsungPayServiceId;
    }

    @NotNull
    public final List<String> getSamsungPaySupportedCardBrands() {
        return this.samsungPaySupportedCardBrands;
    }

    @NotNull
    public final String getVenmoAccessToken() {
        return this.venmoAccessToken;
    }

    @NotNull
    public final String getVenmoEnvironment() {
        return this.venmoEnvironment;
    }

    @NotNull
    public final String getVenmoMerchantId() {
        return this.venmoMerchantId;
    }

    public final boolean getVenmoEnrichedCustomerDataEnabled() {
        return this.venmoEnrichedCustomerDataEnabled;
    }

    @NotNull
    public final String getVisaCheckoutApiKey() {
        return this.visaCheckoutApiKey;
    }

    @NotNull
    public final String getVisaCheckoutExternalClientId() {
        return this.visaCheckoutExternalClientId;
    }

    @NotNull
    public final List<String> getVisaCheckoutSupportedNetworks() {
        return this.visaCheckoutSupportedNetworks;
    }

    @NotNull
    public String toJson() {
        return this.configurationString;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public final boolean isGraphQLFeatureEnabled(@NotNull String feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return this.graphQLConfiguration.isFeatureEnabled(feature);
    }

    @JvmStatic
    @NotNull
    public static final Configuration fromJson(@Nullable String configurationString) throws JSONException {
        return Companion.fromJson(configurationString);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/braintreepayments/api/Configuration$Companion;", "", "()V", "ASSETS_URL_KEY", "", "BRAINTREE_API_KEY", "CARDINAL_AUTHENTICATION_JWT", "CARD_KEY", "CHALLENGES_KEY", "CLIENT_API_URL_KEY", "ENVIRONMENT_KEY", "GOOGLE_PAY_KEY", "GRAPHQL_KEY", "MERCHANT_ACCOUNT_ID_KEY", "MERCHANT_ID_KEY", "PAYPAL_ENABLED_KEY", "PAYPAL_KEY", "PAY_WITH_VENMO_KEY", "SAMSUNG_PAY_KEY", "THREE_D_SECURE_ENABLED_KEY", "UNIONPAY_KEY", "VISA_CHECKOUT_KEY", "fromJson", "Lcom/braintreepayments/api/Configuration;", "configurationString", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Configuration fromJson(@Nullable String configurationString) throws JSONException {
            return new Configuration(configurationString);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

