/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.util.Base64;
import androidx.annotation.RestrictTo;
import com.braintreepayments.api.Authorization;
import com.braintreepayments.api.InvalidArgumentException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/braintreepayments/api/ClientToken;", "Lcom/braintreepayments/api/Authorization;", "clientTokenString", "", "(Ljava/lang/String;)V", "authorizationFingerprint", "getAuthorizationFingerprint", "()Ljava/lang/String;", "bearer", "getBearer", "configUrl", "getConfigUrl", "customerId", "getCustomerId", "Companion", "BraintreeCore_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ClientToken
extends Authorization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String configUrl;
    @NotNull
    private final String bearer;
    @NotNull
    private final String authorizationFingerprint;
    @Nullable
    private final String customerId;
    @NotNull
    public static final String BASE_64_MATCHER = "([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)";
    @NotNull
    private static final String CONFIG_URL_KEY = "configUrl";
    @NotNull
    private static final String AUTHORIZATION_FINGERPRINT_KEY = "authorizationFingerprint";

    public ClientToken(@NotNull String clientTokenString) throws InvalidArgumentException {
        Intrinsics.checkNotNullParameter((Object)clientTokenString, (String)"clientTokenString");
        super(clientTokenString);
        try {
            byte[] byArray = Base64.decode((String)clientTokenString, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(clientTokenString, Base64.DEFAULT)");
            byte[] byArray2 = byArray;
            String clientTokenStringDecoded = new String(byArray2, Charsets.UTF_8);
            JSONObject jsonObject = new JSONObject(clientTokenStringDecoded);
            String string = jsonObject.getString(CONFIG_URL_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.getString(CONFIG_URL_KEY)");
            this.configUrl = string;
            String string2 = jsonObject.getString(AUTHORIZATION_FINGERPRINT_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject.getString(AUT\u2026RIZATION_FINGERPRINT_KEY)");
            this.bearer = this.authorizationFingerprint = string2;
            this.customerId = ClientToken.Companion.parseCustomerId(this.authorizationFingerprint);
        }
        catch (NullPointerException e) {
            throw new InvalidArgumentException("Client token was invalid");
        }
        catch (JSONException e) {
            throw new InvalidArgumentException("Client token was invalid");
        }
    }

    @Override
    @NotNull
    public String getConfigUrl() {
        return this.configUrl;
    }

    @Override
    @NotNull
    public String getBearer() {
        return this.bearer;
    }

    @NotNull
    public final String getAuthorizationFingerprint() {
        return this.authorizationFingerprint;
    }

    @Nullable
    public final String getCustomerId() {
        return this.customerId;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/braintreepayments/api/ClientToken$Companion;", "", "()V", "AUTHORIZATION_FINGERPRINT_KEY", "", "BASE_64_MATCHER", "CONFIG_URL_KEY", "parseCustomerId", "authorizationFingerprint", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String parseCustomerId(String authorizationFingerprint) {
            if (authorizationFingerprint != null) {
                String fingerPrint = authorizationFingerprint;
                boolean bl = false;
                String[] stringArray = new String[]{"&"};
                List components = StringsKt.split$default((CharSequence)fingerPrint, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                for (String component : components) {
                    if (!StringsKt.contains$default((CharSequence)component, (CharSequence)"customer_id=", (boolean)false, (int)2, null)) continue;
                    String[] stringArray2 = new String[]{"="};
                    List customerComponents = StringsKt.split$default((CharSequence)component, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                    if (customerComponents.size() <= 1) continue;
                    return (String)customerComponents.get(1);
                }
                return null;
            }
            Object result = null;
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

