/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import com.braintreepayments.api.AuthorizationException;
import com.braintreepayments.api.BaseHttpResponseParser;
import com.braintreepayments.api.ErrorWithResponse;
import com.braintreepayments.api.HttpResponseParser;
import com.braintreepayments.api.UnprocessableEntityException;
import java.net.HttpURLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/braintreepayments/api/BraintreeHttpResponseParser;", "Lcom/braintreepayments/api/HttpResponseParser;", "baseParser", "(Lcom/braintreepayments/api/HttpResponseParser;)V", "parse", "", "responseCode", "", "connection", "Ljava/net/HttpURLConnection;", "Companion", "BraintreeCore_release"})
public final class BraintreeHttpResponseParser
implements HttpResponseParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpResponseParser baseParser;
    private static final int AUTH_ERROR_CODE = 403;
    private static final int UNPROCESSABLE_ENTITY_ERROR_CODE = 422;

    public BraintreeHttpResponseParser(@NotNull HttpResponseParser baseParser) {
        Intrinsics.checkNotNullParameter((Object)baseParser, (String)"baseParser");
        this.baseParser = baseParser;
    }

    public /* synthetic */ BraintreeHttpResponseParser(HttpResponseParser httpResponseParser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            httpResponseParser = (HttpResponseParser)new BaseHttpResponseParser();
        }
        this(httpResponseParser);
    }

    @NotNull
    public String parse(int responseCode, @NotNull HttpURLConnection connection) throws Exception {
        String string;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        try {
            String string2 = this.baseParser.parse(responseCode, connection);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n        baseParser.par\u2026seCode, connection)\n    }");
            string = string2;
        }
        catch (AuthorizationException e) {
            String errorMessage = new ErrorWithResponse(403, e.getMessage()).getMessage();
            throw new AuthorizationException(errorMessage);
        }
        catch (UnprocessableEntityException e) {
            throw new ErrorWithResponse(422, e.getMessage());
        }
        return string;
    }

    public BraintreeHttpResponseParser() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/braintreepayments/api/BraintreeHttpResponseParser$Companion;", "", "()V", "AUTH_ERROR_CODE", "", "UNPROCESSABLE_ENTITY_ERROR_CODE", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

