/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.net.Uri;
import com.braintreepayments.api.Authorization;
import com.braintreepayments.api.BraintreeException;
import com.braintreepayments.api.BraintreeHttpResponseParser;
import com.braintreepayments.api.ClientToken;
import com.braintreepayments.api.Configuration;
import com.braintreepayments.api.HttpClient;
import com.braintreepayments.api.HttpRequest;
import com.braintreepayments.api.HttpResponseCallback;
import com.braintreepayments.api.HttpResponseParser;
import com.braintreepayments.api.InvalidAuthorization;
import com.braintreepayments.api.TLSCertificatePinning;
import com.braintreepayments.api.TLSSocketFactory;
import com.braintreepayments.api.TokenizationKey;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J5\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0086\u0002J*\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ2\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/braintreepayments/api/BraintreeHttpClient;", "", "httpClient", "Lcom/braintreepayments/api/HttpClient;", "(Lcom/braintreepayments/api/HttpClient;)V", "get", "", "path", "", "configuration", "Lcom/braintreepayments/api/Configuration;", "authorization", "Lcom/braintreepayments/api/Authorization;", "callback", "Lcom/braintreepayments/api/HttpResponseCallback;", "retryStrategy", "", "post", "data", "Companion", "BraintreeCore_release"})
public final class BraintreeHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private static final String AUTHORIZATION_FINGERPRINT_KEY = "authorizationFingerprint";
    @NotNull
    private static final String USER_AGENT_HEADER = "User-Agent";
    @NotNull
    private static final String CLIENT_KEY_HEADER = "Client-Key";

    public BraintreeHttpClient(@NotNull HttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.httpClient = httpClient;
    }

    public /* synthetic */ BraintreeHttpClient(HttpClient httpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            httpClient = BraintreeHttpClient.Companion.createDefaultHttpClient();
        }
        this(httpClient);
    }

    public final void get(@NotNull String path, @Nullable Configuration configuration, @Nullable Authorization authorization, @NotNull HttpResponseCallback callback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.get(path, configuration, authorization, 0, callback);
    }

    public final void get(@NotNull String path, @Nullable Configuration configuration, @Nullable Authorization authorization, int retryStrategy, @NotNull HttpResponseCallback callback) {
        boolean isRelativeURL;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (authorization instanceof InvalidAuthorization) {
            String message = ((InvalidAuthorization)authorization).getErrorMessage();
            callback.onResult(null, (Exception)new BraintreeException(message, null, 2, null));
            return;
        }
        boolean bl = isRelativeURL = !StringsKt.startsWith$default((String)path, (String)"http", (boolean)false, (int)2, null);
        if (configuration == null && isRelativeURL) {
            String message = "Braintree HTTP GET request without configuration cannot have a relative path.";
            BraintreeException relativeURLNotAllowedError = new BraintreeException(message, null, 2, null);
            callback.onResult(null, (Exception)relativeURLNotAllowedError);
            return;
        }
        String relativeURLNotAllowedError = authorization instanceof ClientToken ? Uri.parse((String)path).buildUpon().appendQueryParameter(AUTHORIZATION_FINGERPRINT_KEY, ((ClientToken)authorization).getBearer()).toString() : path;
        Intrinsics.checkNotNullExpressionValue((Object)relativeURLNotAllowedError, (String)"if (authorization is Cli\u2026           path\n        }");
        String targetPath = relativeURLNotAllowedError;
        HttpRequest request = new HttpRequest().method("GET").path(targetPath).addHeader(USER_AGENT_HEADER, "braintree/android/4.45.1");
        if (isRelativeURL && configuration != null) {
            request.baseUrl(configuration.getClientApiUrl());
        }
        if (authorization instanceof TokenizationKey) {
            request.addHeader(CLIENT_KEY_HEADER, ((TokenizationKey)authorization).getBearer());
        }
        this.httpClient.sendRequest(request, retryStrategy, callback);
    }

    public final void post(@NotNull String path, @NotNull String data, @Nullable Configuration configuration, @Nullable Authorization authorization, @NotNull HttpResponseCallback callback) {
        String string;
        boolean isRelativeURL;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (authorization instanceof InvalidAuthorization) {
            String message = ((InvalidAuthorization)authorization).getErrorMessage();
            callback.onResult(null, (Exception)new BraintreeException(message, null, 2, null));
            return;
        }
        boolean bl = isRelativeURL = !StringsKt.startsWith$default((String)path, (String)"http", (boolean)false, (int)2, null);
        if (configuration == null && isRelativeURL) {
            String message = "Braintree HTTP GET request without configuration cannot have a relative path.";
            BraintreeException relativeURLNotAllowedError = new BraintreeException(message, null, 2, null);
            callback.onResult(null, (Exception)relativeURLNotAllowedError);
            return;
        }
        if (authorization instanceof ClientToken) {
            String string2;
            try {
                string2 = new JSONObject(data).put(AUTHORIZATION_FINGERPRINT_KEY, (Object)((ClientToken)authorization).getAuthorizationFingerprint()).toString();
            }
            catch (JSONException e) {
                callback.onResult(null, (Exception)((Object)e));
                return;
            }
            string = string2;
        } else {
            string = data;
        }
        String relativeURLNotAllowedError = string;
        Intrinsics.checkNotNullExpressionValue((Object)relativeURLNotAllowedError, (String)"if (authorization is Cli\u2026           data\n        }");
        String requestData = relativeURLNotAllowedError;
        HttpRequest request = new HttpRequest().method("POST").path(path).data(requestData).addHeader(USER_AGENT_HEADER, "braintree/android/4.45.1");
        if (isRelativeURL && configuration != null) {
            request.baseUrl(configuration.getClientApiUrl());
        }
        if (authorization instanceof TokenizationKey) {
            request.addHeader(CLIENT_KEY_HEADER, ((TokenizationKey)authorization).getBearer());
        }
        this.httpClient.sendRequest(request, callback);
    }

    @NotNull
    public final String post(@NotNull String path, @NotNull String data, @Nullable Configuration configuration, @Nullable Authorization authorization) throws Exception {
        boolean isRelativeURL;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (authorization instanceof InvalidAuthorization) {
            String message = ((InvalidAuthorization)authorization).getErrorMessage();
            throw new BraintreeException(message, null, 2, null);
        }
        boolean bl = isRelativeURL = !StringsKt.startsWith$default((String)path, (String)"http", (boolean)false, (int)2, null);
        if (configuration == null && isRelativeURL) {
            String message = "Braintree HTTP GET request without configuration cannot have a relative path.";
            throw new BraintreeException(message, null, 2, null);
        }
        String string = authorization instanceof ClientToken ? new JSONObject(data).put(AUTHORIZATION_FINGERPRINT_KEY, (Object)((ClientToken)authorization).getAuthorizationFingerprint()).toString() : data;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (authorization is Cli\u2026           data\n        }");
        String requestData = string;
        HttpRequest request = new HttpRequest().method("POST").path(path).data(requestData).addHeader(USER_AGENT_HEADER, "braintree/android/4.45.1");
        if (isRelativeURL && configuration != null) {
            request.baseUrl(configuration.getClientApiUrl());
        }
        if (authorization instanceof TokenizationKey) {
            request.addHeader(CLIENT_KEY_HEADER, ((TokenizationKey)authorization).getBearer());
        }
        String string2 = this.httpClient.sendRequest(request);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"httpClient.sendRequest(request)");
        return string2;
    }

    public BraintreeHttpClient() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/braintreepayments/api/BraintreeHttpClient$Companion;", "", "()V", "AUTHORIZATION_FINGERPRINT_KEY", "", "CLIENT_KEY_HEADER", "USER_AGENT_HEADER", "createDefaultHttpClient", "Lcom/braintreepayments/api/HttpClient;", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        private final HttpClient createDefaultHttpClient() {
            TLSSocketFactory socketFactory = new TLSSocketFactory(TLSCertificatePinning.INSTANCE.getCertInputStream());
            return new HttpClient((SSLSocketFactory)socketFactory, (HttpResponseParser)new BraintreeHttpResponseParser(null, 1, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

