/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.AuthorizationException;
import com.braintreepayments.api.BaseHttpResponseParser;
import com.braintreepayments.api.ErrorWithResponse;
import com.braintreepayments.api.HttpResponseParser;
import com.braintreepayments.api.Json;
import com.braintreepayments.api.UnexpectedException;
import java.net.HttpURLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/braintreepayments/api/BraintreeGraphQLResponseParser;", "Lcom/braintreepayments/api/HttpResponseParser;", "()V", "baseParser", "(Lcom/braintreepayments/api/HttpResponseParser;)V", "parse", "", "responseCode", "", "connection", "Ljava/net/HttpURLConnection;", "BraintreeCore_release"})
public final class BraintreeGraphQLResponseParser
implements HttpResponseParser {
    @NotNull
    private final HttpResponseParser baseParser;

    @VisibleForTesting
    public BraintreeGraphQLResponseParser(@NotNull HttpResponseParser baseParser) {
        Intrinsics.checkNotNullParameter((Object)baseParser, (String)"baseParser");
        this.baseParser = baseParser;
    }

    public BraintreeGraphQLResponseParser() {
        this((HttpResponseParser)new BaseHttpResponseParser());
    }

    @NotNull
    public String parse(int responseCode, @NotNull HttpURLConnection connection) throws Exception {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        String response = this.baseParser.parse(responseCode, connection);
        JSONArray errors = new JSONObject(response).optJSONArray("errors");
        if (errors == null) {
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            return response;
        }
        int n = errors.length();
        for (int i = 0; i < n; ++i) {
            JSONObject error = errors.getJSONObject(i);
            JSONObject extensions = error.optJSONObject("extensions");
            String message = Json.optString((JSONObject)error, (String)"message", (String)"An Unexpected Exception Occurred");
            if (extensions == null) {
                throw new UnexpectedException(message);
            }
            String legacyCode = Json.optString((JSONObject)extensions, (String)"legacyCode", (String)"");
            String errorType = Json.optString((JSONObject)extensions, (String)"errorType", (String)"");
            if (Intrinsics.areEqual((Object)legacyCode, (Object)"50000")) {
                throw new AuthorizationException(error.getString("message"));
            }
            if (Intrinsics.areEqual((Object)errorType, (Object)"user_error")) continue;
            throw new UnexpectedException(message);
        }
        throw ErrorWithResponse.Companion.fromGraphQLJson$BraintreeCore_release(response);
    }
}

