/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import com.braintreepayments.api.Authorization;
import com.braintreepayments.api.BraintreeException;
import com.braintreepayments.api.BraintreeGraphQLResponseParser;
import com.braintreepayments.api.Configuration;
import com.braintreepayments.api.HttpClient;
import com.braintreepayments.api.HttpRequest;
import com.braintreepayments.api.HttpResponseCallback;
import com.braintreepayments.api.HttpResponseParser;
import com.braintreepayments.api.InvalidAuthorization;
import com.braintreepayments.api.TLSCertificatePinning;
import com.braintreepayments.api.TLSSocketFactory;
import java.util.Arrays;
import java.util.Locale;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ*\u0010\u0005\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ2\u0010\u0005\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/braintreepayments/api/BraintreeGraphQLClient;", "", "httpClient", "Lcom/braintreepayments/api/HttpClient;", "(Lcom/braintreepayments/api/HttpClient;)V", "post", "", "data", "", "configuration", "Lcom/braintreepayments/api/Configuration;", "authorization", "Lcom/braintreepayments/api/Authorization;", "callback", "Lcom/braintreepayments/api/HttpResponseCallback;", "path", "Companion", "BraintreeCore_release"})
public final class BraintreeGraphQLClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpClient httpClient;

    public BraintreeGraphQLClient(@NotNull HttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.httpClient = httpClient;
    }

    public /* synthetic */ BraintreeGraphQLClient(HttpClient httpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            httpClient = BraintreeGraphQLClient.Companion.createDefaultHttpClient();
        }
        this(httpClient);
    }

    public final void post(@Nullable String path, @Nullable String data, @NotNull Configuration configuration, @NotNull Authorization authorization, @NotNull HttpResponseCallback callback) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (authorization instanceof InvalidAuthorization) {
            String message = ((InvalidAuthorization)authorization).getErrorMessage();
            callback.onResult(null, (Exception)new BraintreeException(message, null, 2, null));
            return;
        }
        HttpRequest httpRequest = new HttpRequest().method("POST").path(path).data(data).baseUrl(configuration.getGraphQLUrl()).addHeader("User-Agent", "braintree/android/4.45.1");
        Locale locale = Locale.US;
        String string = "Bearer %s";
        Object[] objectArray = new Object[]{authorization.getBearer()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        HttpRequest request = httpRequest.addHeader("Authorization", string2).addHeader("Braintree-Version", "2018-03-06");
        this.httpClient.sendRequest(request, callback);
    }

    public final void post(@Nullable String data, @NotNull Configuration configuration, @NotNull Authorization authorization, @NotNull HttpResponseCallback callback) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (authorization instanceof InvalidAuthorization) {
            String message = ((InvalidAuthorization)authorization).getErrorMessage();
            callback.onResult(null, (Exception)new BraintreeException(message, null, 2, null));
            return;
        }
        HttpRequest httpRequest = new HttpRequest().method("POST").path("").data(data).baseUrl(configuration.getGraphQLUrl()).addHeader("User-Agent", "braintree/android/4.45.1");
        Locale locale = Locale.US;
        String string = "Bearer %s";
        Object[] objectArray = new Object[]{authorization.getBearer()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        HttpRequest request = httpRequest.addHeader("Authorization", string2).addHeader("Braintree-Version", "2018-03-06");
        this.httpClient.sendRequest(request, callback);
    }

    @NotNull
    public final String post(@Nullable String path, @Nullable String data, @NotNull Configuration configuration, @NotNull Authorization authorization) throws Exception {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        if (authorization instanceof InvalidAuthorization) {
            String message = ((InvalidAuthorization)authorization).getErrorMessage();
            throw new BraintreeException(message, null, 2, null);
        }
        HttpRequest httpRequest = new HttpRequest().method("POST").path(path).data(data).baseUrl(configuration.getGraphQLUrl()).addHeader("User-Agent", "braintree/android/4.45.1");
        Locale locale = Locale.US;
        String string = "Bearer %s";
        Object[] objectArray = new Object[]{authorization.getBearer()};
        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, format, *args)");
        HttpRequest request = httpRequest.addHeader("Authorization", string2).addHeader("Braintree-Version", "2018-03-06");
        String string3 = this.httpClient.sendRequest(request);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"httpClient.sendRequest(request)");
        return string3;
    }

    public BraintreeGraphQLClient() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lcom/braintreepayments/api/BraintreeGraphQLClient$Companion;", "", "()V", "createDefaultHttpClient", "Lcom/braintreepayments/api/HttpClient;", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        private final HttpClient createDefaultHttpClient() {
            TLSSocketFactory socketFactory = new TLSSocketFactory(TLSCertificatePinning.INSTANCE.getCertInputStream());
            return new HttpClient((SSLSocketFactory)socketFactory, (HttpResponseParser)new BraintreeGraphQLResponseParser());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

