/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import com.braintreepayments.api.ClientToken;
import com.braintreepayments.api.InvalidArgumentException;
import com.braintreepayments.api.InvalidAuthorization;
import com.braintreepayments.api.TokenizationKey;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b'\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/braintreepayments/api/Authorization;", "", "rawValue", "", "(Ljava/lang/String;)V", "bearer", "getBearer", "()Ljava/lang/String;", "configUrl", "getConfigUrl", "toString", "Companion", "BraintreeCore_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class Authorization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rawValue;

    public Authorization(@NotNull String rawValue) {
        Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
        this.rawValue = rawValue;
    }

    @Nullable
    public abstract String getConfigUrl();

    @Nullable
    public abstract String getBearer();

    @NotNull
    public String toString() {
        return this.rawValue;
    }

    @JvmStatic
    @NotNull
    public static final Authorization fromString(@Nullable String authorizationString) {
        return Companion.fromString(authorizationString);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lcom/braintreepayments/api/Authorization$Companion;", "", "()V", "fromString", "Lcom/braintreepayments/api/Authorization;", "authorizationString", "", "isClientToken", "", "clientToken", "isTokenizationKey", "tokenizationKey", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Authorization fromString(@Nullable String authorizationString) {
            Authorization authorization;
            String errorMessage;
            String authTrimmed;
            String string;
            String string2 = authorizationString;
            if (string2 != null) {
                String $this$trim$iv = string2;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            } else {
                string = authTrimmed = null;
            }
            if (authTrimmed == null || TextUtils.isEmpty((CharSequence)authorizationString)) {
                errorMessage = "Authorization provided is invalid: " + authTrimmed;
                String string3 = authTrimmed;
                if (string3 == null) {
                    string3 = "null";
                }
                return new InvalidAuthorization(string3, errorMessage);
            }
            try {
                Authorization authorization2;
                if (this.isTokenizationKey(authTrimmed)) {
                    authorization2 = new TokenizationKey(authTrimmed);
                } else if (this.isClientToken(authTrimmed)) {
                    authorization2 = new ClientToken(authTrimmed);
                } else {
                    errorMessage = "Authorization provided is invalid: " + authTrimmed;
                    authorization2 = new InvalidAuthorization(authTrimmed, errorMessage);
                }
                authorization = authorization2;
            }
            catch (InvalidArgumentException error) {
                String string4 = error.getMessage();
                Intrinsics.checkNotNull((Object)string4);
                authorization = new InvalidAuthorization(authTrimmed, string4);
            }
            return authorization;
        }

        private final boolean isTokenizationKey(String tokenizationKey) {
            CharSequence charSequence = tokenizationKey;
            return new Regex("^[a-zA-Z0-9]+_[a-zA-Z0-9]+_[a-zA-Z0-9_]+$").matches(charSequence);
        }

        private final boolean isClientToken(String clientToken) {
            CharSequence charSequence = clientToken;
            return new Regex("([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)").matches(charSequence);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

