/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import androidx.annotation.RestrictTo;
import com.braintreepayments.api.BraintreeClient;
import com.braintreepayments.api.HttpResponseCallback;
import com.braintreepayments.api.PaymentMethod;
import com.braintreepayments.api.TokenizeCallback;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/braintreepayments/api/ApiClient;", "", "braintreeClient", "Lcom/braintreepayments/api/BraintreeClient;", "(Lcom/braintreepayments/api/BraintreeClient;)V", "parseResponseToJSON", "Lorg/json/JSONObject;", "responseBody", "", "tokenizeGraphQL", "", "tokenizePayload", "callback", "Lcom/braintreepayments/api/TokenizeCallback;", "tokenizeREST", "paymentMethod", "Lcom/braintreepayments/api/PaymentMethod;", "Companion", "BraintreeCore_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BraintreeClient braintreeClient;
    @NotNull
    public static final String PAYMENT_METHOD_ENDPOINT = "payment_methods";

    public ApiClient(@NotNull BraintreeClient braintreeClient) {
        Intrinsics.checkNotNullParameter((Object)braintreeClient, (String)"braintreeClient");
        this.braintreeClient = braintreeClient;
    }

    public final void tokenizeGraphQL(@NotNull JSONObject tokenizePayload, @NotNull TokenizeCallback callback) {
        Intrinsics.checkNotNullParameter((Object)tokenizePayload, (String)"tokenizePayload");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        BraintreeClient $this$tokenizeGraphQL_u24lambda_u2d0 = this.braintreeClient;
        boolean bl = false;
        BraintreeClient.sendAnalyticsEvent$default($this$tokenizeGraphQL_u24lambda_u2d0, "card.graphql.tokenization.started", null, null, false, 14, null);
        $this$tokenizeGraphQL_u24lambda_u2d0.sendGraphQLPOST(tokenizePayload.toString(), new HttpResponseCallback(this, $this$tokenizeGraphQL_u24lambda_u2d0, callback){
            final /* synthetic */ ApiClient this$0;
            final /* synthetic */ BraintreeClient $this_run;
            final /* synthetic */ TokenizeCallback $callback;
            {
                this.this$0 = $receiver;
                this.$this_run = $receiver2;
                this.$callback = $callback;
            }

            public void onResult(@Nullable String responseBody, @Nullable Exception httpError) {
                block1: {
                    block0: {
                        JSONObject jSONObject = ApiClient.access$parseResponseToJSON(this.this$0, responseBody);
                        if (jSONObject == null) break block0;
                        JSONObject jSONObject2 = jSONObject;
                        BraintreeClient braintreeClient = this.$this_run;
                        TokenizeCallback tokenizeCallback = this.$callback;
                        JSONObject json = jSONObject2;
                        boolean bl = false;
                        BraintreeClient.sendAnalyticsEvent$default(braintreeClient, "card.graphql.tokenization.success", null, null, false, 14, null);
                        tokenizeCallback.onResult(json, null);
                        break block1;
                    }
                    Exception exception = httpError;
                    if (exception == null) break block1;
                    Exception exception2 = exception;
                    BraintreeClient braintreeClient = this.$this_run;
                    TokenizeCallback tokenizeCallback = this.$callback;
                    Exception error = exception2;
                    boolean bl = false;
                    BraintreeClient.sendAnalyticsEvent$default(braintreeClient, "card.graphql.tokenization.failure", null, null, false, 14, null);
                    tokenizeCallback.onResult(null, error);
                }
            }
        });
    }

    public final void tokenizeREST(@NotNull PaymentMethod paymentMethod, @NotNull TokenizeCallback callback) {
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        BraintreeClient $this$tokenizeREST_u24lambda_u2d1 = this.braintreeClient;
        boolean bl = false;
        String url = Companion.versionedPath("payment_methods/" + paymentMethod.getApiPath());
        paymentMethod.setSessionId(this.braintreeClient.getSessionId());
        BraintreeClient.sendAnalyticsEvent$default($this$tokenizeREST_u24lambda_u2d1, "card.rest.tokenization.started", null, null, false, 14, null);
        $this$tokenizeREST_u24lambda_u2d1.sendPOST(url, String.valueOf(paymentMethod.buildJSON()), new HttpResponseCallback(this, $this$tokenizeREST_u24lambda_u2d1, callback){
            final /* synthetic */ ApiClient this$0;
            final /* synthetic */ BraintreeClient $this_run;
            final /* synthetic */ TokenizeCallback $callback;
            {
                this.this$0 = $receiver;
                this.$this_run = $receiver2;
                this.$callback = $callback;
            }

            public void onResult(@Nullable String responseBody, @Nullable Exception httpError) {
                block1: {
                    block0: {
                        JSONObject jSONObject = ApiClient.access$parseResponseToJSON(this.this$0, responseBody);
                        if (jSONObject == null) break block0;
                        JSONObject jSONObject2 = jSONObject;
                        BraintreeClient braintreeClient = this.$this_run;
                        TokenizeCallback tokenizeCallback = this.$callback;
                        JSONObject json = jSONObject2;
                        boolean bl = false;
                        BraintreeClient.sendAnalyticsEvent$default(braintreeClient, "card.rest.tokenization.success", null, null, false, 14, null);
                        tokenizeCallback.onResult(json, null);
                        break block1;
                    }
                    Exception exception = httpError;
                    if (exception == null) break block1;
                    Exception exception2 = exception;
                    BraintreeClient braintreeClient = this.$this_run;
                    TokenizeCallback tokenizeCallback = this.$callback;
                    Exception error = exception2;
                    boolean bl = false;
                    BraintreeClient.sendAnalyticsEvent$default(braintreeClient, "card.rest.tokenization.failure", null, null, false, 14, null);
                    tokenizeCallback.onResult(null, error);
                }
            }
        });
    }

    private final JSONObject parseResponseToJSON(String responseBody) {
        JSONObject jSONObject;
        String string = responseBody;
        if (string != null) {
            JSONObject jSONObject2;
            String it = string;
            boolean bl = false;
            try {
                jSONObject2 = new JSONObject(it);
            }
            catch (JSONException e) {
                jSONObject2 = null;
            }
            jSONObject = jSONObject2;
        } else {
            jSONObject = null;
        }
        return jSONObject;
    }

    @JvmStatic
    @NotNull
    public static final String versionedPath(@NotNull String path) {
        return Companion.versionedPath(path);
    }

    public static final /* synthetic */ JSONObject access$parseResponseToJSON(ApiClient $this, String responseBody) {
        return $this.parseResponseToJSON(responseBody);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/braintreepayments/api/ApiClient$Companion;", "", "()V", "PAYMENT_METHOD_ENDPOINT", "", "versionedPath", "path", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String versionedPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return "/v1/" + path;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

