/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.braintreepayments.api.AnalyticsEvent;
import com.braintreepayments.api.AnalyticsEventDao;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AnalyticsEventDao_Impl
implements AnalyticsEventDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AnalyticsEvent> __insertionAdapterOfAnalyticsEvent;
    private final EntityDeletionOrUpdateAdapter<AnalyticsEvent> __deletionAdapterOfAnalyticsEvent;

    public AnalyticsEventDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAnalyticsEvent = new EntityInsertionAdapter<AnalyticsEvent>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `analytics_event` (`name`,`paypal_context_id`,`link_type`,`timestamp`,`venmo_installed`,`is_vault`,`_id`) VALUES (?,?,?,?,?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, AnalyticsEvent value) {
                if (value.getName() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getName());
                }
                if (value.getPayPalContextId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPayPalContextId());
                }
                if (value.getLinkType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getLinkType());
                }
                stmt.bindLong(4, value.getTimestamp());
                int _tmp = value.getVenmoInstalled() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp);
                int _tmp_1 = value.isVaultRequest() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_1);
                stmt.bindLong(7, value.id);
            }
        };
        this.__deletionAdapterOfAnalyticsEvent = new EntityDeletionOrUpdateAdapter<AnalyticsEvent>(__db){

            public String createQuery() {
                return "DELETE FROM `analytics_event` WHERE `_id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AnalyticsEvent value) {
                stmt.bindLong(1, value.id);
            }
        };
    }

    @Override
    public void insertEvent(AnalyticsEvent event) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfAnalyticsEvent.insert((Object)event);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteEvents(List<? extends AnalyticsEvent> events) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfAnalyticsEvent.handleMultiple(events);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AnalyticsEvent> getAllEvents() {
        String _sql = "SELECT * FROM analytics_event";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM analytics_event", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfPayPalContextId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"paypal_context_id");
            int _cursorIndexOfLinkType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"link_type");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfVenmoInstalled = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"venmo_installed");
            int _cursorIndexOfIsVaultRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"is_vault");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"_id");
            ArrayList<AnalyticsEvent> _result = new ArrayList<AnalyticsEvent>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpPayPalContextId = _cursor.isNull(_cursorIndexOfPayPalContextId) ? null : _cursor.getString(_cursorIndexOfPayPalContextId);
                String _tmpLinkType = _cursor.isNull(_cursorIndexOfLinkType) ? null : _cursor.getString(_cursorIndexOfLinkType);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                int _tmp = _cursor.getInt(_cursorIndexOfVenmoInstalled);
                boolean _tmpVenmoInstalled = _tmp != 0;
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsVaultRequest);
                boolean _tmpIsVaultRequest = _tmp_1 != 0;
                AnalyticsEvent _item = new AnalyticsEvent(_tmpName, _tmpPayPalContextId, _tmpLinkType, _tmpTimestamp, _tmpVenmoInstalled, _tmpIsVaultRequest);
                _item.id = _cursor.getLong(_cursorIndexOfId);
                _result.add(_item);
            }
            ArrayList<AnalyticsEvent> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

