/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.braintreepayments.api.AnalyticsDatabase;
import com.braintreepayments.api.AnalyticsEvent;
import com.braintreepayments.api.AnalyticsEventDao;
import com.braintreepayments.api.AnalyticsUploadWorker;
import com.braintreepayments.api.AnalyticsWriteToDbWorker;
import com.braintreepayments.api.Authorization;
import com.braintreepayments.api.BraintreeHttpClient;
import com.braintreepayments.api.ClientToken;
import com.braintreepayments.api.Configuration;
import com.braintreepayments.api.DeviceInspector;
import com.braintreepayments.api.DeviceMetadata;
import com.braintreepayments.api.HttpNoResponse;
import com.braintreepayments.api.HttpResponseCallback;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ8\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016JB\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J,\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J2\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016J(\u0010\u001f\u001a\u00020 2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020&2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/braintreepayments/api/AnalyticsClient;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "httpClient", "Lcom/braintreepayments/api/BraintreeHttpClient;", "analyticsDatabase", "Lcom/braintreepayments/api/AnalyticsDatabase;", "workManager", "Landroidx/work/WorkManager;", "deviceInspector", "Lcom/braintreepayments/api/DeviceInspector;", "(Lcom/braintreepayments/api/BraintreeHttpClient;Lcom/braintreepayments/api/AnalyticsDatabase;Landroidx/work/WorkManager;Lcom/braintreepayments/api/DeviceInspector;)V", "reportCrash", "", "configuration", "Lcom/braintreepayments/api/Configuration;", "sessionId", "", "integration", "authorization", "Lcom/braintreepayments/api/Authorization;", "timestamp", "", "scheduleAnalyticsUpload", "Ljava/util/UUID;", "scheduleAnalyticsWrite", "event", "Lcom/braintreepayments/api/AnalyticsEvent;", "sendEvent", "serializeEvents", "Lorg/json/JSONObject;", "events", "", "metadata", "Lcom/braintreepayments/api/DeviceMetadata;", "uploadAnalytics", "Landroidx/work/ListenableWorker$Result;", "inputData", "Landroidx/work/Data;", "writeAnalytics", "Companion", "BraintreeCore_release"})
public final class AnalyticsClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BraintreeHttpClient httpClient;
    @NotNull
    private final AnalyticsDatabase analyticsDatabase;
    @NotNull
    private final WorkManager workManager;
    @NotNull
    private final DeviceInspector deviceInspector;
    @NotNull
    private static final String FPTI_ANALYTICS_URL = "https://api-m.paypal.com/v1/tracking/batch/events";
    @NotNull
    private static final String PAYPAL_CONTEXT_ID_KEY = "paypal_context_id";
    @NotNull
    private static final String VENMO_INSTALLED_KEY = "venmo_installed";
    @NotNull
    private static final String IS_VAULT_REQUEST_KEY = "is_vault";
    @NotNull
    private static final String LINK_TYPE_KEY = "link_type";
    @NotNull
    private static final String TOKENIZATION_KEY = "tokenization_key";
    @NotNull
    private static final String AUTHORIZATION_FINGERPRINT_KEY = "authorization_fingerprint";
    private static final long INVALID_TIMESTAMP = -1L;
    @NotNull
    private static final String EVENTS_CONTAINER_KEY = "events";
    @NotNull
    private static final String BATCH_PARAMS_KEY = "batch_params";
    @NotNull
    private static final String EVENT_PARAMS_KEY = "event_params";
    @NotNull
    private static final String EVENT_NAME_KEY = "event_name";
    @NotNull
    private static final String TIMESTAMP_KEY = "t";
    @NotNull
    private static final String TENANT_NAME_KEY = "tenant_name";
    @NotNull
    public static final String WORK_NAME_ANALYTICS_UPLOAD = "uploadAnalytics";
    @NotNull
    public static final String WORK_NAME_ANALYTICS_WRITE = "writeAnalyticsToDb";
    @NotNull
    public static final String WORK_INPUT_KEY_AUTHORIZATION = "authorization";
    @NotNull
    public static final String WORK_INPUT_KEY_CONFIGURATION = "configuration";
    @NotNull
    public static final String WORK_INPUT_KEY_EVENT_NAME = "eventName";
    @NotNull
    public static final String WORK_INPUT_KEY_INTEGRATION = "integration";
    @NotNull
    public static final String WORK_INPUT_KEY_SESSION_ID = "sessionId";
    @NotNull
    public static final String WORK_INPUT_KEY_TIMESTAMP = "timestamp";
    @NotNull
    public static final String WORK_INPUT_KEY_PAYPAL_CONTEXT_ID = "payPalContextId";
    @NotNull
    public static final String WORK_INPUT_KEY_VENMO_INSTALLED = "venmoInstalled";
    @NotNull
    public static final String WORK_INPUT_KEY_IS_VAULT_REQUEST = "isVaultRequest";
    @NotNull
    public static final String WORK_INPUT_KEY_LINK_TYPE = "linkType";
    private static final long DELAY_TIME_SECONDS = 30L;

    @VisibleForTesting
    public AnalyticsClient(@NotNull BraintreeHttpClient httpClient, @NotNull AnalyticsDatabase analyticsDatabase, @NotNull WorkManager workManager, @NotNull DeviceInspector deviceInspector) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)((Object)analyticsDatabase), (String)"analyticsDatabase");
        Intrinsics.checkNotNullParameter((Object)workManager, (String)"workManager");
        Intrinsics.checkNotNullParameter((Object)deviceInspector, (String)"deviceInspector");
        this.httpClient = httpClient;
        this.analyticsDatabase = analyticsDatabase;
        this.workManager = workManager;
        this.deviceInspector = deviceInspector;
    }

    public AnalyticsClient(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BraintreeHttpClient braintreeHttpClient = new BraintreeHttpClient(null, 1, null);
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        AnalyticsDatabase analyticsDatabase = AnalyticsDatabase.Companion.getInstance(context2);
        WorkManager workManager = WorkManager.getInstance((Context)context.getApplicationContext());
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context.applicationContext)");
        this(braintreeHttpClient, analyticsDatabase, workManager, new DeviceInspector());
    }

    @NotNull
    public final UUID sendEvent(@NotNull Configuration configuration, @NotNull AnalyticsEvent event, @Nullable String sessionId, @Nullable String integration, @NotNull Authorization authorization) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)WORK_INPUT_KEY_CONFIGURATION);
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)authorization, (String)WORK_INPUT_KEY_AUTHORIZATION);
        this.scheduleAnalyticsWrite(event, authorization);
        return this.scheduleAnalyticsUpload(configuration, authorization, sessionId, integration);
    }

    private final void scheduleAnalyticsWrite(AnalyticsEvent event, Authorization authorization) {
        Data data = new Data.Builder().putString(WORK_INPUT_KEY_AUTHORIZATION, authorization.toString()).putString(WORK_INPUT_KEY_EVENT_NAME, "android." + event.getName()).putString(WORK_INPUT_KEY_PAYPAL_CONTEXT_ID, event.getPayPalContextId()).putString(WORK_INPUT_KEY_LINK_TYPE, event.getLinkType()).putLong(WORK_INPUT_KEY_TIMESTAMP, event.getTimestamp()).putBoolean(WORK_INPUT_KEY_VENMO_INSTALLED, event.getVenmoInstalled()).putBoolean(WORK_INPUT_KEY_IS_VAULT_REQUEST, event.isVaultRequest()).build();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"Builder()\n            .p\u2026est)\n            .build()");
        Data inputData = data;
        WorkRequest workRequest = ((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(AnalyticsWriteToDbWorker.class).setInputData(inputData)).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(AnalyticsWriteTo\u2026\n                .build()");
        OneTimeWorkRequest analyticsWorkRequest = (OneTimeWorkRequest)workRequest;
        this.workManager.enqueueUniqueWork(WORK_NAME_ANALYTICS_WRITE, ExistingWorkPolicy.APPEND_OR_REPLACE, analyticsWorkRequest);
    }

    @NotNull
    public final ListenableWorker.Result writeAnalytics(@NotNull Data inputData) {
        ListenableWorker.Result result;
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        String eventName = inputData.getString(WORK_INPUT_KEY_EVENT_NAME);
        String payPalContextId = inputData.getString(WORK_INPUT_KEY_PAYPAL_CONTEXT_ID);
        String linkType = inputData.getString(WORK_INPUT_KEY_LINK_TYPE);
        long timestamp = inputData.getLong(WORK_INPUT_KEY_TIMESTAMP, -1L);
        boolean venmoInstalled = inputData.getBoolean(WORK_INPUT_KEY_VENMO_INSTALLED, false);
        boolean isVaultRequest = inputData.getBoolean(WORK_INPUT_KEY_IS_VAULT_REQUEST, false);
        if (eventName == null || timestamp == -1L) {
            ListenableWorker.Result result2 = ListenableWorker.Result.failure();
            result = result2;
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"{\n            Listenable\u2026esult.failure()\n        }");
        } else {
            AnalyticsEvent event = new AnalyticsEvent(eventName, payPalContextId, linkType, timestamp, venmoInstalled, isVaultRequest);
            AnalyticsEventDao analyticsEventDao = this.analyticsDatabase.analyticsEventDao();
            analyticsEventDao.insertEvent(event);
            ListenableWorker.Result result3 = ListenableWorker.Result.success();
            result = result3;
            Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"{\n            val event \u2026esult.success()\n        }");
        }
        return result;
    }

    private final UUID scheduleAnalyticsUpload(Configuration configuration, Authorization authorization, String sessionId, String integration) {
        Data data = new Data.Builder().putString(WORK_INPUT_KEY_AUTHORIZATION, authorization.toString()).putString(WORK_INPUT_KEY_CONFIGURATION, configuration.toJson()).putString(WORK_INPUT_KEY_SESSION_ID, sessionId).putString(WORK_INPUT_KEY_INTEGRATION, integration).build();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"Builder()\n            .p\u2026ion)\n            .build()");
        Data inputData = data;
        WorkRequest workRequest = ((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(AnalyticsUploadWorker.class).setInitialDelay(30L, TimeUnit.SECONDS)).setInputData(inputData)).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(AnalyticsUploadW\u2026ata)\n            .build()");
        OneTimeWorkRequest analyticsWorkRequest = (OneTimeWorkRequest)workRequest;
        this.workManager.enqueueUniqueWork(WORK_NAME_ANALYTICS_UPLOAD, ExistingWorkPolicy.KEEP, analyticsWorkRequest);
        UUID uUID = analyticsWorkRequest.getId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"analyticsWorkRequest.id");
        return uUID;
    }

    @NotNull
    public final ListenableWorker.Result uploadAnalytics(@Nullable Context context, @NotNull Data inputData) {
        ListenableWorker.Result result;
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        Configuration configuration = AnalyticsClient.Companion.getConfigurationFromData(inputData);
        Authorization authorization = AnalyticsClient.Companion.getAuthorizationFromData(inputData);
        String sessionId = inputData.getString(WORK_INPUT_KEY_SESSION_ID);
        String integration = inputData.getString(WORK_INPUT_KEY_INTEGRATION);
        Object[] objectArray = new Object[]{configuration, authorization, sessionId, integration};
        boolean isMissingInputData = CollectionsKt.listOf((Object[])objectArray).contains(null);
        if (isMissingInputData) {
            ListenableWorker.Result result2 = ListenableWorker.Result.failure();
            result = result2;
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"{\n            Listenable\u2026esult.failure()\n        }");
        } else {
            Object[] objectArray2;
            try {
                AnalyticsEventDao analyticsEventDao = this.analyticsDatabase.analyticsEventDao();
                List<AnalyticsEvent> events = analyticsEventDao.getAllEvents();
                if (!((Collection)events).isEmpty()) {
                    DeviceMetadata metadata = this.deviceInspector.getDeviceMetadata$BraintreeCore_release(context, configuration, sessionId, integration);
                    JSONObject analyticsRequest = this.serializeEvents(authorization, events, metadata);
                    String string = analyticsRequest.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"analyticsRequest.toString()");
                    this.httpClient.post(FPTI_ANALYTICS_URL, string, configuration, authorization);
                    analyticsEventDao.deleteEvents(events);
                }
                objectArray2 = ListenableWorker.Result.success();
            }
            catch (Exception e) {
                objectArray2 = ListenableWorker.Result.failure();
            }
            objectArray = objectArray2;
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"{\n            try {\n    \u2026)\n            }\n        }");
            result = objectArray;
        }
        return result;
    }

    public final void reportCrash(@Nullable Context context, @Nullable Configuration configuration, @Nullable String sessionId, @Nullable String integration, @Nullable Authorization authorization) {
        this.reportCrash(context, configuration, sessionId, integration, System.currentTimeMillis(), authorization);
    }

    @VisibleForTesting
    public final void reportCrash(@Nullable Context context, @Nullable Configuration configuration, @Nullable String sessionId, @Nullable String integration, long timestamp, @Nullable Authorization authorization) {
        if (authorization == null) {
            return;
        }
        DeviceMetadata metadata = this.deviceInspector.getDeviceMetadata$BraintreeCore_release(context, configuration, sessionId, integration);
        AnalyticsEvent event = new AnalyticsEvent("android.crash", null, null, timestamp, false, false, 48, null);
        List events = CollectionsKt.listOf((Object)event);
        try {
            JSONObject analyticsRequest = this.serializeEvents(authorization, events, metadata);
            String string = analyticsRequest.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"analyticsRequest.toString()");
            this.httpClient.post(FPTI_ANALYTICS_URL, string, null, authorization, (HttpResponseCallback)new HttpNoResponse());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private final JSONObject serializeEvents(Authorization authorization, List<? extends AnalyticsEvent> events, DeviceMetadata metadata) throws JSONException {
        JSONObject jSONObject;
        JSONObject batchParamsJSON = metadata.toJSON();
        Authorization authorization2 = authorization;
        if (authorization2 != null) {
            Authorization it = authorization2;
            boolean bl = false;
            jSONObject = it instanceof ClientToken ? batchParamsJSON.put(AUTHORIZATION_FINGERPRINT_KEY, (Object)((ClientToken)it).getBearer()) : batchParamsJSON.put(TOKENIZATION_KEY, (Object)it.getBearer());
        } else {
            jSONObject = null;
        }
        JSONObject eventsContainerJSON = new JSONObject();
        eventsContainerJSON.put(BATCH_PARAMS_KEY, (Object)batchParamsJSON);
        JSONArray eventParamsJSON = new JSONArray();
        for (AnalyticsEvent jSONObjectArray : events) {
            JSONObject singleEventJSON = new JSONObject().put(EVENT_NAME_KEY, (Object)jSONObjectArray.getName()).putOpt(PAYPAL_CONTEXT_ID_KEY, (Object)jSONObjectArray.getPayPalContextId()).putOpt(LINK_TYPE_KEY, (Object)jSONObjectArray.getLinkType()).put(TIMESTAMP_KEY, jSONObjectArray.getTimestamp()).put(VENMO_INSTALLED_KEY, jSONObjectArray.getVenmoInstalled()).put(IS_VAULT_REQUEST_KEY, jSONObjectArray.isVaultRequest()).put(TENANT_NAME_KEY, (Object)"Braintree");
            eventParamsJSON.put((Object)singleEventJSON);
        }
        eventsContainerJSON.put(EVENT_PARAMS_KEY, (Object)eventParamsJSON);
        JSONObject[] jSONObjectArray = new JSONObject[]{eventsContainerJSON};
        JSONArray eventsArray = new JSONArray((Object)jSONObjectArray);
        JSONObject jSONObject2 = new JSONObject().put(EVENTS_CONTAINER_KEY, (Object)eventsArray);
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"JSONObject().put(EVENTS_\u2026NTAINER_KEY, eventsArray)");
        return jSONObject2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0014\u0010$\u001a\u0004\u0018\u00010%2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/braintreepayments/api/AnalyticsClient$Companion;", "", "()V", "AUTHORIZATION_FINGERPRINT_KEY", "", "BATCH_PARAMS_KEY", "DELAY_TIME_SECONDS", "", "EVENTS_CONTAINER_KEY", "EVENT_NAME_KEY", "EVENT_PARAMS_KEY", "FPTI_ANALYTICS_URL", "INVALID_TIMESTAMP", "IS_VAULT_REQUEST_KEY", "LINK_TYPE_KEY", "PAYPAL_CONTEXT_ID_KEY", "TENANT_NAME_KEY", "TIMESTAMP_KEY", "TOKENIZATION_KEY", "VENMO_INSTALLED_KEY", "WORK_INPUT_KEY_AUTHORIZATION", "WORK_INPUT_KEY_CONFIGURATION", "WORK_INPUT_KEY_EVENT_NAME", "WORK_INPUT_KEY_INTEGRATION", "WORK_INPUT_KEY_IS_VAULT_REQUEST", "WORK_INPUT_KEY_LINK_TYPE", "WORK_INPUT_KEY_PAYPAL_CONTEXT_ID", "WORK_INPUT_KEY_SESSION_ID", "WORK_INPUT_KEY_TIMESTAMP", "WORK_INPUT_KEY_VENMO_INSTALLED", "WORK_NAME_ANALYTICS_UPLOAD", "WORK_NAME_ANALYTICS_WRITE", "getAuthorizationFromData", "Lcom/braintreepayments/api/Authorization;", "inputData", "Landroidx/work/Data;", "getConfigurationFromData", "Lcom/braintreepayments/api/Configuration;", "BraintreeCore_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Authorization getAuthorizationFromData(Data inputData) {
            Authorization authorization;
            Object object = inputData;
            if (object != null && (object = object.getString(AnalyticsClient.WORK_INPUT_KEY_AUTHORIZATION)) != null) {
                Object it = object;
                boolean bl = false;
                authorization = Authorization.Companion.fromString((String)it);
            } else {
                authorization = null;
            }
            return authorization;
        }

        private final Configuration getConfigurationFromData(Data inputData) {
            Configuration configuration;
            Object object = inputData;
            if (object != null && (object = object.getString(AnalyticsClient.WORK_INPUT_KEY_CONFIGURATION)) != null) {
                Configuration configuration2;
                Object it = object;
                boolean bl = false;
                try {
                    configuration2 = Configuration.Companion.fromJson((String)it);
                }
                catch (JSONException ignored) {
                    configuration2 = null;
                }
                configuration = configuration2;
            } else {
                configuration = null;
            }
            return configuration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

