/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.rules.Assign;
import com.bpodgursky.jbool_expressions.rules.QuineMcCluskey;
import com.bpodgursky.jbool_expressions.rules.RulesHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class RuleSet {
    private static final int QMC_CARDINALITY_CUTOFF = 8;

    public static <K> Expression<K> simplify(Expression<K> root) {
        return RulesHelper.applySet(root, RulesHelper.simplifyRules());
    }

    public static <K> Expression<K> toDNFViaQMC(Expression<K> root) {
        HashSet variables = new HashSet();
        root.collectK(variables, 9);
        if (variables.size() <= 8) {
            return QuineMcCluskey.toDNF(root);
        }
        return RuleSet.toSop(root);
    }

    public static <K> Expression<K> toSop(Expression<K> root) {
        return RulesHelper.applySet(RulesHelper.applySet(root, RulesHelper.demorganRules()), RulesHelper.toSopRules());
    }

    public static <K> Expression<K> toPos(Expression<K> root) {
        Not<K> inverse = Not.of(root);
        Expression<K> sopInv = RuleSet.toSop(inverse);
        Not<K> inverse2 = Not.of(sopInv);
        return RulesHelper.applySet(inverse2, RulesHelper.demorganRules());
    }

    public static <K> Expression<K> assign(Expression<K> root, Map<K, Boolean> values) {
        ArrayList rules = new ArrayList(RulesHelper.simplifyRules());
        rules.add(new Assign<K>(values));
        return RulesHelper.applySet(root, rules);
    }

    public static <K> Expression<K> toDNF(Expression<K> root) {
        return RuleSet.toSop(root);
    }

    public static <K> Expression<K> toCNF(Expression<K> root) {
        return RuleSet.toPos(root);
    }
}

