/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.ExprUtil;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.NExpression;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.rules.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExtractCommon<K>
extends Rule<NExpression<K>, K> {
    private boolean oppositeNExpr(NExpression<K> first, Expression<K> second) {
        if (first instanceof And) {
            return second instanceof Or;
        }
        if (first instanceof Or) {
            return second instanceof And;
        }
        throw new RuntimeException();
    }

    private NExpression<K> ofSame(NExpression<K> first, List<? extends Expression<K>> others) {
        return first.create(others.toArray(new Expression[others.size()]));
    }

    private NExpression<K> ofOpposite(NExpression<K> first, List<? extends Expression<K>> others) {
        if (first instanceof And) {
            return Or.of(others);
        }
        if (first instanceof Or) {
            return And.of(others);
        }
        throw new RuntimeException();
    }

    @Override
    public Expression<K> applyInternal(NExpression<K> input) {
        HashMap<Expression, Set> byParent = new HashMap<Expression, Set>();
        for (Expression<K> expression : input.getChildren()) {
            if (!this.oppositeNExpr(input, expression)) continue;
            NExpression inner = (NExpression)expression;
            for (Expression expression2 : inner.getChildren()) {
                Set nExpressionSet = byParent.computeIfAbsent(expression2, k -> new HashSet());
                nExpressionSet.add(inner);
            }
        }
        for (Expression<K> expression : byParent.keySet()) {
            Set common = (Set)byParent.get(expression);
            if (common.size() <= 1) continue;
            ArrayList remainder = new ArrayList();
            for (NExpression subExpr : common) {
                Expression<K>[] remaining = ExprUtil.allExceptMatch(subExpr.getChildren(), expression);
                remainder.add(subExpr.create(remaining));
            }
            ArrayList<Expression<K>> arrayList = new ArrayList<Expression<K>>(Arrays.asList(ExprUtil.allExceptMatch(input.getChildren(), common)));
            arrayList.add(this.ofOpposite(input, new ArrayList<Expression>(Arrays.asList(expression, this.ofSame(input, remainder)))));
            if (arrayList.size() > 1) {
                return this.ofSame(input, arrayList);
            }
            return (Expression)arrayList.get(0);
        }
        return input;
    }

    @Override
    protected boolean isApply(Expression<K> input) {
        return input instanceof NExpression;
    }
}

