/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.And;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.NExpression;
import com.bpodgursky.jbool_expressions.Or;
import com.bpodgursky.jbool_expressions.rules.Rule;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplifyNExpression<K>
extends Rule<NExpression<K>, K> {
    @Override
    public Expression<K> applyInternal(NExpression<K> input) {
        if (input.expressions.length == 1) {
            return input.expressions[0];
        }
        for (int i = 0; i < input.expressions.length - 1; ++i) {
            if (!input.expressions[i].equals(input.expressions[i + 1])) continue;
            return this.simplify(input);
        }
        return input;
    }

    @Override
    protected boolean isApply(Expression<K> input) {
        return input instanceof NExpression;
    }

    private Expression<K> simplify(NExpression<K> input) {
        int i = 1;
        int j = 1;
        ArrayList copy = Lists.newArrayList();
        copy.add(input.expressions[0]);
        while (i < input.expressions.length) {
            Expression internal;
            if ((internal = input.expressions[i++]).equals((Expression)copy.get(j - 1))) continue;
            copy.add(internal);
            ++j;
        }
        return this.build(copy, input);
    }

    private NExpression<K> build(List<Expression<K>> contents, NExpression<K> input) {
        if (input instanceof And) {
            return And.of(contents);
        }
        return Or.of(contents);
    }
}

