/*
 * Decompiled with CFR 0.152.
 */
package com.bozapro.circularsliderrange;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.bozapro.circularsliderrange.R;
import com.bozapro.circularsliderrange.ThumbEvent;

public class CircularSliderRange
extends View {
    private int mThumbStartX;
    private int mThumbStartY;
    private int mThumbEndX;
    private int mThumbEndY;
    private int mCircleCenterX;
    private int mCircleCenterY;
    private int mCircleRadius;
    private Drawable mStartThumbImage;
    private Drawable mEndThumbImage;
    private int mPadding;
    private int mThumbSize;
    private int mStartThumbColor;
    private int mEndThumbColor;
    private int mBorderColor;
    private int mBorderThickness;
    private int mArcDashSize;
    private int mArcColor;
    private double mAngle;
    private double mAngleEnd;
    private boolean mIsThumbSelected = false;
    private boolean mIsThumbEndSelected = false;
    private Paint mPaint = new Paint();
    private Paint mLinePaint = new Paint();
    private RectF arcRectF = new RectF();
    private Rect arcRect = new Rect();
    private OnSliderRangeMovedListener mListener;

    public CircularSliderRange(Context context) {
        this(context, null);
    }

    public CircularSliderRange(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircularSliderRange(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public CircularSliderRange(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        int padding;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircularSlider, defStyleAttr, 0);
        float startAngle = a.getFloat(R.styleable.CircularSlider_start_angle, 90.0f);
        float endAngle = a.getFloat(R.styleable.CircularSlider_end_angle, 60.0f);
        int thumbSize = a.getDimensionPixelSize(R.styleable.CircularSlider_thumb_size, 50);
        int thumbColor = a.getColor(R.styleable.CircularSlider_start_thumb_color, -7829368);
        int thumbEndColor = a.getColor(R.styleable.CircularSlider_end_thumb_color, -7829368);
        int borderThickness = a.getDimensionPixelSize(R.styleable.CircularSlider_border_thickness, 20);
        int arcDashSize = a.getDimensionPixelSize(R.styleable.CircularSlider_arc_dash_size, 60);
        int arcColor = a.getColor(R.styleable.CircularSlider_arc_color, 0);
        int borderColor = a.getColor(R.styleable.CircularSlider_border_color, -65536);
        Drawable thumbImage = a.getDrawable(R.styleable.CircularSlider_start_thumb_image);
        Drawable thumbEndImage = a.getDrawable(R.styleable.CircularSlider_end_thumb_image);
        this.setStartAngle(startAngle);
        this.setEndAngle(endAngle);
        this.setBorderThickness(borderThickness);
        this.setBorderColor(borderColor);
        this.setThumbSize(thumbSize);
        this.setStartThumbImage(thumbImage);
        this.setEndThumbImage(thumbEndImage);
        this.setStartThumbColor(thumbColor);
        this.setEndThumbColor(thumbEndColor);
        this.setArcColor(arcColor);
        this.setArcDashSize(arcDashSize);
        if (Build.VERSION.SDK_INT >= 17) {
            int all = this.getPaddingLeft() + this.getPaddingRight() + this.getPaddingBottom() + this.getPaddingTop() + this.getPaddingEnd() + this.getPaddingStart();
            padding = all / 6;
        } else {
            padding = (this.getPaddingLeft() + this.getPaddingRight() + this.getPaddingBottom() + this.getPaddingTop()) / 4;
        }
        this.setPadding(padding);
        a.recycle();
        if (this.isInEditMode()) {
            return;
        }
    }

    public void setStartAngle(double startAngle) {
        this.mAngle = this.fromDrawingAngle(startAngle);
    }

    public void setEndAngle(double angle) {
        this.mAngleEnd = this.fromDrawingAngle(angle);
    }

    public void setThumbSize(int thumbSize) {
        this.mThumbSize = thumbSize;
    }

    public void setBorderThickness(int circleBorderThickness) {
        this.mBorderThickness = circleBorderThickness;
    }

    public void setBorderColor(int color) {
        this.mBorderColor = color;
    }

    public void setStartThumbImage(Drawable drawable) {
        this.mStartThumbImage = drawable;
    }

    public void setEndThumbImage(Drawable drawable) {
        this.mEndThumbImage = drawable;
    }

    public void setStartThumbColor(int color) {
        this.mStartThumbColor = color;
    }

    public void setEndThumbColor(int color) {
        this.mEndThumbColor = color;
    }

    public void setPadding(int padding) {
        this.mPadding = padding;
    }

    public void setArcColor(int color) {
        this.mArcColor = color;
    }

    public void setArcDashSize(int value) {
        this.mArcDashSize = value;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        int smallerDim = w > h ? h : w;
        int largestCenteredSquareLeft = (w - smallerDim) / 2;
        int largestCenteredSquareTop = (h - smallerDim) / 2;
        int largestCenteredSquareRight = largestCenteredSquareLeft + smallerDim;
        int largestCenteredSquareBottom = largestCenteredSquareTop + smallerDim;
        this.mCircleCenterX = largestCenteredSquareRight / 2 + (w - largestCenteredSquareRight) / 2;
        this.mCircleCenterY = largestCenteredSquareBottom / 2 + (h - largestCenteredSquareBottom) / 2;
        this.mCircleRadius = smallerDim / 2 - this.mBorderThickness / 2 - this.mPadding;
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setColor(this.mBorderColor);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth((float)this.mBorderThickness);
        this.mPaint.setAntiAlias(true);
        canvas.drawCircle((float)this.mCircleCenterX, (float)this.mCircleCenterY, (float)this.mCircleRadius, this.mPaint);
        this.mThumbStartX = (int)((double)this.mCircleCenterX + (double)this.mCircleRadius * Math.cos(this.mAngle));
        this.mThumbStartY = (int)((double)this.mCircleCenterY - (double)this.mCircleRadius * Math.sin(this.mAngle));
        this.mThumbEndX = (int)((double)this.mCircleCenterX + (double)this.mCircleRadius * Math.cos(this.mAngleEnd));
        this.mThumbEndY = (int)((double)this.mCircleCenterY - (double)this.mCircleRadius * Math.sin(this.mAngleEnd));
        this.mLinePaint.setColor(this.mArcColor == 0 ? -65536 : this.mArcColor);
        this.mLinePaint.setStyle(Paint.Style.STROKE);
        this.mLinePaint.setStrokeWidth((float)this.mArcDashSize);
        this.mLinePaint.setAntiAlias(true);
        this.mLinePaint.setTextSize(50.0f);
        this.arcRect.set(this.mCircleCenterX - this.mCircleRadius, this.mCircleCenterY + this.mCircleRadius, this.mCircleCenterX + this.mCircleRadius, this.mCircleCenterY - this.mCircleRadius);
        this.arcRectF.set(this.arcRect);
        this.arcRectF.sort();
        float drawStart = this.toDrawingAngle(this.mAngle);
        float drawEnd = this.toDrawingAngle(this.mAngleEnd);
        canvas.drawArc(this.arcRectF, drawStart, (360.0f + drawEnd - drawStart) % 360.0f, false, this.mLinePaint);
        if (this.mStartThumbImage != null) {
            this.mStartThumbImage.setBounds(this.mThumbStartX - this.mThumbSize / 2, this.mThumbStartY - this.mThumbSize / 2, this.mThumbStartX + this.mThumbSize / 2, this.mThumbStartY + this.mThumbSize / 2);
            this.mStartThumbImage.draw(canvas);
        } else {
            this.mPaint.setColor(this.mStartThumbColor);
            this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawCircle((float)this.mThumbStartX, (float)this.mThumbStartY, (float)(this.mThumbSize / 2), this.mPaint);
        }
        if (this.mEndThumbImage != null) {
            this.mEndThumbImage.setBounds(this.mThumbEndX - this.mThumbSize / 2, this.mThumbEndY - this.mThumbSize / 2, this.mThumbEndX + this.mThumbSize / 2, this.mThumbEndY + this.mThumbSize / 2);
            this.mEndThumbImage.draw(canvas);
        } else {
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(this.mEndThumbColor);
            canvas.drawCircle((float)this.mThumbEndX, (float)this.mThumbEndY, (float)(this.mThumbSize / 2), this.mPaint);
        }
    }

    private void updateSliderState(int touchX, int touchY, Thumb thumb) {
        int distanceX = touchX - this.mCircleCenterX;
        int distanceY = this.mCircleCenterY - touchY;
        double c = Math.sqrt(Math.pow(distanceX, 2.0) + Math.pow(distanceY, 2.0));
        double angle = Math.acos((double)distanceX / c);
        if (distanceY < 0) {
            angle = -angle;
        }
        if (thumb == Thumb.START) {
            this.mAngle = angle;
        } else {
            this.mAngleEnd = angle;
        }
        if (this.mListener != null) {
            if (thumb == Thumb.START) {
                this.mListener.onStartSliderMoved(this.toDrawingAngle(angle));
            } else {
                this.mListener.onEndSliderMoved(this.toDrawingAngle(angle));
            }
        }
    }

    private float toDrawingAngle(double angleInRadians) {
        double fixedAngle = Math.toDegrees(angleInRadians);
        fixedAngle = angleInRadians > 0.0 ? 360.0 - fixedAngle : -fixedAngle;
        return (float)fixedAngle;
    }

    private double fromDrawingAngle(double angleInDegrees) {
        double radians = Math.toRadians(angleInDegrees);
        return -radians;
    }

    public void setOnSliderRangeMovedListener(OnSliderRangeMovedListener listener) {
        this.mListener = listener;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                boolean isThumbEndPressed;
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                boolean isThumbStartPressed = x < this.mThumbStartX + this.mThumbSize && x > this.mThumbStartX - this.mThumbSize && y < this.mThumbStartY + this.mThumbSize && y > this.mThumbStartY - this.mThumbSize;
                boolean bl = isThumbEndPressed = x < this.mThumbEndX + this.mThumbSize && x > this.mThumbEndX - this.mThumbSize && y < this.mThumbEndY + this.mThumbSize && y > this.mThumbEndY - this.mThumbSize;
                if (isThumbStartPressed) {
                    this.mIsThumbSelected = true;
                    this.updateSliderState(x, y, Thumb.START);
                } else if (isThumbEndPressed) {
                    this.mIsThumbEndSelected = true;
                    this.updateSliderState(x, y, Thumb.END);
                }
                if (this.mListener == null) break;
                if (this.mIsThumbSelected) {
                    this.mListener.onStartSliderEvent(ThumbEvent.THUMB_PRESSED);
                }
                if (!this.mIsThumbEndSelected) break;
                this.mListener.onEndSliderEvent(ThumbEvent.THUMB_PRESSED);
                break;
            }
            case 2: {
                if (this.mIsThumbSelected) {
                    int x = (int)ev.getX();
                    int y = (int)ev.getY();
                    this.updateSliderState(x, y, Thumb.START);
                    break;
                }
                if (!this.mIsThumbEndSelected) break;
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                this.updateSliderState(x, y, Thumb.END);
                break;
            }
            case 1: {
                if (this.mListener != null) {
                    if (this.mIsThumbSelected) {
                        this.mListener.onStartSliderEvent(ThumbEvent.THUMB_RELEASED);
                    }
                    if (this.mIsThumbEndSelected) {
                        this.mListener.onEndSliderEvent(ThumbEvent.THUMB_RELEASED);
                    }
                }
                this.mIsThumbSelected = false;
                this.mIsThumbEndSelected = false;
            }
        }
        this.invalidate();
        return true;
    }

    private static enum Thumb {
        START,
        END;

    }

    public static interface OnSliderRangeMovedListener {
        public void onStartSliderMoved(double var1);

        public void onEndSliderMoved(double var1);

        public void onStartSliderEvent(ThumbEvent var1);

        public void onEndSliderEvent(ThumbEvent var1);
    }
}

