/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.shieldlists;

import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.shieldlists.CreateShieldListV2025R0Headers;
import com.box.sdkgen.managers.shieldlists.DeleteShieldListByIdV2025R0Headers;
import com.box.sdkgen.managers.shieldlists.GetShieldListByIdV2025R0Headers;
import com.box.sdkgen.managers.shieldlists.GetShieldListsV2025R0Headers;
import com.box.sdkgen.managers.shieldlists.UpdateShieldListByIdV2025R0Headers;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.v2025r0.shieldlistscreatev2025r0.ShieldListsCreateV2025R0;
import com.box.sdkgen.schemas.v2025r0.shieldlistsupdatev2025r0.ShieldListsUpdateV2025R0;
import com.box.sdkgen.schemas.v2025r0.shieldlistsv2025r0.ShieldListsV2025R0;
import com.box.sdkgen.schemas.v2025r0.shieldlistv2025r0.ShieldListV2025R0;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class ShieldListsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public ShieldListsManager() {
        this.networkSession = new NetworkSession();
    }

    protected ShieldListsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public ShieldListsV2025R0 getShieldListsV2025R0() {
        return this.getShieldListsV2025R0(new GetShieldListsV2025R0Headers());
    }

    public ShieldListsV2025R0 getShieldListsV2025R0(GetShieldListsV2025R0Headers headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/shield_lists"), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), ShieldListsV2025R0.class);
    }

    public ShieldListV2025R0 createShieldListV2025R0(ShieldListsCreateV2025R0 requestBody) {
        return this.createShieldListV2025R0(requestBody, new CreateShieldListV2025R0Headers());
    }

    public ShieldListV2025R0 createShieldListV2025R0(ShieldListsCreateV2025R0 requestBody, CreateShieldListV2025R0Headers headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/shield_lists"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), ShieldListV2025R0.class);
    }

    public ShieldListV2025R0 getShieldListByIdV2025R0(String shieldListId) {
        return this.getShieldListByIdV2025R0(shieldListId, new GetShieldListByIdV2025R0Headers());
    }

    public ShieldListV2025R0 getShieldListByIdV2025R0(String shieldListId, GetShieldListByIdV2025R0Headers headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/shield_lists/", UtilsManager.convertToString(shieldListId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), ShieldListV2025R0.class);
    }

    public void deleteShieldListByIdV2025R0(String shieldListId) {
        this.deleteShieldListByIdV2025R0(shieldListId, new DeleteShieldListByIdV2025R0Headers());
    }

    public void deleteShieldListByIdV2025R0(String shieldListId, DeleteShieldListByIdV2025R0Headers headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/shield_lists/", UtilsManager.convertToString(shieldListId)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public ShieldListV2025R0 updateShieldListByIdV2025R0(String shieldListId, ShieldListsUpdateV2025R0 requestBody) {
        return this.updateShieldListByIdV2025R0(shieldListId, requestBody, new UpdateShieldListByIdV2025R0Headers());
    }

    public ShieldListV2025R0 updateShieldListByIdV2025R0(String shieldListId, ShieldListsUpdateV2025R0 requestBody, UpdateShieldListByIdV2025R0Headers headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(UtilsManager.entryOf("box-version", UtilsManager.convertToString(headers.getBoxVersion()))), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/shield_lists/", UtilsManager.convertToString(shieldListId)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), ShieldListV2025R0.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public ShieldListsManager build() {
            return new ShieldListsManager(this);
        }
    }
}

