/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.recentitems;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.recentitems.GetRecentItemsHeaders;
import com.box.sdkgen.managers.recentitems.GetRecentItemsQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.recentitems.RecentItems;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class RecentItemsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public RecentItemsManager() {
        this.networkSession = new NetworkSession();
    }

    protected RecentItemsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public RecentItems getRecentItems() {
        return this.getRecentItems(new GetRecentItemsQueryParams(), new GetRecentItemsHeaders());
    }

    public RecentItems getRecentItems(GetRecentItemsQueryParams queryParams) {
        return this.getRecentItems(queryParams, new GetRecentItemsHeaders());
    }

    public RecentItems getRecentItems(GetRecentItemsHeaders headers) {
        return this.getRecentItems(new GetRecentItemsQueryParams(), headers);
    }

    public RecentItems getRecentItems(GetRecentItemsQueryParams queryParams, GetRecentItemsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit())), UtilsManager.entryOf("marker", UtilsManager.convertToString(queryParams.getMarker()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/recent_items"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), RecentItems.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public RecentItemsManager build() {
            return new RecentItemsManager(this);
        }
    }
}

