package com.box.sdkgen.managers.listcollaborations;

import static com.box.sdkgen.internal.utils.UtilsManager.mapOf;

import java.util.Map;

public class GetGroupCollaborationsHeaders {

  public Map<String, String> extraHeaders;

  public GetGroupCollaborationsHeaders() {
    this.extraHeaders = mapOf();
  }

  protected GetGroupCollaborationsHeaders(Builder builder) {
    this.extraHeaders = builder.extraHeaders;
  }

  public Map<String, String> getExtraHeaders() {
    return extraHeaders;
  }

  public static class Builder {

    protected Map<String, String> extraHeaders;

    public Builder() {
      this.extraHeaders = mapOf();
    }

    public Builder extraHeaders(Map<String, String> extraHeaders) {
      this.extraHeaders = extraHeaders;
      return this;
    }

    public GetGroupCollaborationsHeaders build() {
      return new GetGroupCollaborationsHeaders(this);
    }
  }
}
