/*
 * Decompiled with CFR 0.152.
 */
package com.bowyer.app.parsesendclient;

import com.bowyer.app.parsesendclient.Api;
import com.bowyer.app.parsesendclient.ApiCreater;
import com.bowyer.app.parsesendclient.DateUtil;
import com.bowyer.app.parsesendclient.ParsePushDto;
import java.util.Calendar;
import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class PushSendLogic {
    public static final String TAG = PushSendLogic.class.getSimpleName();
    private static PushSendCallBack mPushSendCallBack;

    public static void sendPush(Object model, String[] channels, PushSendCallBack callBack) {
        mPushSendCallBack = callBack;
        ParsePushDto dto = new ParsePushDto().setParsePushModel(model).setChannels(channels);
        PushSendLogic.send(dto);
    }

    public static void sendSchedulingPush(Object model, Calendar calendar, String[] channels, PushSendCallBack callBack) {
        mPushSendCallBack = callBack;
        ParsePushDto dto = new ParsePushDto().setParsePushModel(model).setChannels(channels).setPushTime(DateUtil.getUtcTime(calendar));
        PushSendLogic.send(dto);
    }

    public static void send(ParsePushDto dto) {
        Api api = ApiCreater.getInstance();
        api.sendNotification(dto, new Callback<Api.response>(){

            public void success(Api.response response2, Response response22) {
                if (mPushSendCallBack != null) {
                    mPushSendCallBack.onSuccess();
                }
            }

            public void failure(RetrofitError error) {
                if (mPushSendCallBack != null) {
                    mPushSendCallBack.onFailure(error.getMessage());
                }
            }
        });
    }

    public static interface PushSendCallBack {
        public void onSuccess();

        public void onFailure(String var1);
    }
}

