/*
 * Decompiled with CFR 0.152.
 */
package com.bowyer.app.fabtransitionlayout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.animation.FastOutLinearInInterpolator;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Property;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.bowyer.app.fabtransitionlayout.FooterBehavior;
import com.bowyer.app.fabtransitionlayout.R;
import com.bowyer.app.fabtransitionlayout.ViewUtils;
import io.codetail.animation.SupportAnimator;

@CoordinatorLayout.DefaultBehavior(value=FooterBehavior.class)
public class FooterLayout
extends FrameLayout {
    private static final int DEFAULT_ANIMATION_DURATION = 400;
    private static final int DEFAULT_FAB_SIZE = 56;
    private static final int FAB_CIRCLE = 0;
    private static final int FAB_EXPAND = 1;
    int mFabType = 0;
    boolean mAnimatingFab = false;
    private LinearLayout mFabExpandLayout;
    private ImageView mFab;
    private int animationDuration;
    private int mFabSize;

    public FooterLayout(Context context) {
        super(context);
        this.init();
    }

    public FooterLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        this.loadAttributes(context, attrs);
    }

    public FooterLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
        this.loadAttributes(context, attrs);
    }

    private void init() {
        FooterLayout.inflate((Context)this.getContext(), (int)R.layout.footer_layout, (ViewGroup)this);
        this.mFabExpandLayout = (LinearLayout)this.findViewById(R.id.container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributes(Context context, AttributeSet attrs) {
        int containerGravity;
        TypedValue outValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(R.attr.colorPrimary, outValue, true);
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.FooterLayout, 0, 0);
        try {
            this.setColor(a.getColor(R.styleable.FooterLayout_ft_color, outValue.data));
            this.animationDuration = a.getInteger(R.styleable.FooterLayout_ft_anim_duration, 400);
            containerGravity = a.getInteger(R.styleable.FooterLayout_ft_container_gravity, 1);
            this.mFabSize = a.getInteger(R.styleable.FooterLayout_ft_fab_type, 56);
        }
        finally {
            a.recycle();
        }
        this.mFabExpandLayout.setGravity(this.getGravity(containerGravity));
    }

    public void setFab(ImageView imageView) {
        this.mFab = imageView;
    }

    private int getGravity(int gravityEnum) {
        return (gravityEnum == 0 ? 0x800003 : (gravityEnum == 1 ? 1 : 0x800005)) | 0x10;
    }

    public void setColor(int color) {
        this.mFabExpandLayout.setBackgroundColor(color);
    }

    public void addView(@NonNull View child) {
        if (this.canAddViewToContainer()) {
            this.mFabExpandLayout.addView(child);
        } else {
            super.addView(child);
        }
    }

    public void addView(@NonNull View child, int width, int height) {
        if (this.canAddViewToContainer()) {
            this.mFabExpandLayout.addView(child, width, height);
        } else {
            super.addView(child, width, height);
        }
    }

    public void addView(@NonNull View child, ViewGroup.LayoutParams params) {
        if (this.canAddViewToContainer()) {
            this.mFabExpandLayout.addView(child, params);
        } else {
            super.addView(child, params);
        }
    }

    public void addView(@NonNull View child, int index, ViewGroup.LayoutParams params) {
        if (this.canAddViewToContainer()) {
            this.mFabExpandLayout.addView(child, index, params);
        } else {
            super.addView(child, index, params);
        }
    }

    public void hide() {
        this.mFabExpandLayout.setVisibility(4);
        this.mFabType = 0;
    }

    public void show() {
        this.mFabExpandLayout.setVisibility(0);
        this.mFabType = 1;
    }

    private boolean canAddViewToContainer() {
        return this.mFabExpandLayout != null;
    }

    public void slideInFab() {
        if (this.mAnimatingFab) {
            return;
        }
        if (this.isFabExpanded()) {
            this.contractFab();
            return;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mFab.getLayoutParams();
        float dy = this.mFab.getHeight() + lp.bottomMargin;
        if (this.mFab.getTranslationY() != dy) {
            return;
        }
        this.mAnimatingFab = true;
        this.mFab.setVisibility(0);
        this.mFab.animate().setStartDelay(0L).setDuration(200L).setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator()).translationY(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FooterLayout.this.mAnimatingFab = false;
            }
        }).start();
    }

    public void slideOutFab() {
        if (this.mAnimatingFab) {
            return;
        }
        if (this.isFabExpanded()) {
            this.contractFab();
            return;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mFab.getLayoutParams();
        if (this.mFab.getTranslationY() != 0.0f) {
            return;
        }
        this.mAnimatingFab = true;
        this.mFab.animate().setStartDelay(0L).setDuration(200L).setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator()).translationY((float)(this.mFab.getHeight() + lp.bottomMargin)).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FooterLayout.this.mAnimatingFab = false;
                FooterLayout.this.mFab.setVisibility(4);
            }
        }).start();
    }

    public void expandFab() {
        this.mFabType = 1;
        if (Build.VERSION.SDK_INT < 21) {
            this.expandPreLollipop();
        } else {
            this.expandLollipop();
        }
    }

    public void contractFab() {
        if (!this.isFabExpanded()) {
            return;
        }
        this.mFabType = 0;
        if (Build.VERSION.SDK_INT < 21) {
            this.contractPreLollipop();
        } else {
            this.contractLollipop();
        }
    }

    public boolean isFabExpanded() {
        return this.mFabType == 1;
    }

    @TargetApi(value=21)
    private void expandLollipop() {
        this.mAnimatingFab = true;
        float dx = ViewUtils.centerX((View)this.mFabExpandLayout) + (float)this.getFabSizePx() - ViewUtils.centerX((View)this.mFab);
        float dy = ViewUtils.getRelativeTop((View)this.mFabExpandLayout) - ViewUtils.getRelativeTop((View)this.mFab) - (this.mFab.getHeight() - this.getFabSizePx()) / 2;
        int x = (int)(ViewUtils.centerX((View)this.mFab) + dx);
        int y = (this.mFabExpandLayout.getBottom() - this.mFabExpandLayout.getTop()) / 2;
        float startRadius = this.getFabSizePx() / 2;
        float endRadius = (float)Math.hypot(Math.max(x, this.mFabExpandLayout.getWidth() - x), Math.max(y, this.mFabExpandLayout.getHeight() - y));
        this.mFabExpandLayout.setAlpha(0.0f);
        this.mFabExpandLayout.setVisibility(0);
        ObjectAnimator fabSlideXAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFab, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{0.0f, dx})});
        fabSlideXAnim.setDuration((long)(this.animationDuration / 2));
        ObjectAnimator fabSlideYAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFab, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{0.0f, dy})});
        fabSlideYAnim.setDuration((long)(this.animationDuration / 2));
        Animator toolbarExpandAnim = ViewAnimationUtils.createCircularReveal((View)this.mFabExpandLayout, (int)x, (int)y, (float)startRadius, (float)endRadius);
        toolbarExpandAnim.setStartDelay((long)(this.animationDuration / 2));
        toolbarExpandAnim.setDuration((long)(this.animationDuration / 2));
        AnimatorSet animSet = new AnimatorSet();
        animSet.playTogether(new Animator[]{fabSlideXAnim, fabSlideYAnim, toolbarExpandAnim});
        fabSlideXAnim.setInterpolator((TimeInterpolator)new AccelerateInterpolator(1.0f));
        fabSlideYAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator(0.8f));
        fabSlideYAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FooterLayout.this.mFab.setVisibility(4);
                FooterLayout.this.mFab.setTranslationX(0.0f);
                FooterLayout.this.mFab.setTranslationY(0.0f);
                FooterLayout.this.mFab.setAlpha(1.0f);
            }
        });
        toolbarExpandAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                FooterLayout.this.mFabExpandLayout.setAlpha(1.0f);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FooterLayout.this.mAnimatingFab = false;
            }
        });
        animSet.start();
    }

    private void expandPreLollipop() {
        this.mAnimatingFab = true;
        float dx = ViewUtils.centerX((View)this.mFabExpandLayout) + (float)this.getFabSizePx() - ViewUtils.centerX((View)this.mFab);
        float dy = ViewUtils.getRelativeTop((View)this.mFabExpandLayout) - ViewUtils.getRelativeTop((View)this.mFab) - (this.mFab.getHeight() - this.getFabSizePx()) / 2;
        int x = (int)(ViewUtils.centerX((View)this.mFab) + dx);
        int y = (this.mFabExpandLayout.getBottom() - this.mFabExpandLayout.getTop()) / 2;
        float startRadius = this.getFabSizePx() / 2;
        float endRadius = (float)Math.hypot(Math.max(x, this.mFabExpandLayout.getWidth() - x), Math.max(y, this.mFabExpandLayout.getHeight() - y));
        this.mFabExpandLayout.setAlpha(0.0f);
        this.mFabExpandLayout.setVisibility(0);
        ObjectAnimator fabSlideXAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFab, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{0.0f, dx})});
        fabSlideXAnim.setDuration((long)(this.animationDuration / 2));
        ObjectAnimator fabSlideYAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFab, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{0.0f, dy})});
        fabSlideYAnim.setDuration((long)(this.animationDuration / 2));
        final SupportAnimator toolbarExpandAnim = io.codetail.animation.ViewAnimationUtils.createCircularReveal((View)this.mFabExpandLayout, (int)x, (int)y, (float)startRadius, (float)endRadius);
        toolbarExpandAnim.setDuration((long)(this.animationDuration / 2));
        AnimatorSet animSet = new AnimatorSet();
        animSet.playTogether(new Animator[]{fabSlideXAnim, fabSlideYAnim});
        fabSlideXAnim.setInterpolator((TimeInterpolator)new AccelerateInterpolator(1.0f));
        fabSlideYAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator(0.8f));
        fabSlideYAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FooterLayout.this.mFab.setAlpha(0.0f);
                FooterLayout.this.mFab.setVisibility(4);
                FooterLayout.this.mFab.setTranslationX(0.0f);
                FooterLayout.this.mFab.setTranslationY(0.0f);
                toolbarExpandAnim.start();
            }
        });
        toolbarExpandAnim.addListener(new SupportAnimator.AnimatorListener(){

            public void onAnimationStart() {
                FooterLayout.this.mFabExpandLayout.setAlpha(1.0f);
            }

            public void onAnimationEnd() {
                FooterLayout.this.mFab.setAlpha(1.0f);
                FooterLayout.this.mAnimatingFab = false;
            }

            public void onAnimationCancel() {
            }

            public void onAnimationRepeat() {
            }
        });
        animSet.start();
    }

    @TargetApi(value=21)
    private void contractLollipop() {
        this.mAnimatingFab = true;
        float dx = ViewUtils.centerX((View)this.mFabExpandLayout) + (float)this.getFabSizePx() - ViewUtils.centerX((View)this.mFab);
        float dy = ViewUtils.getRelativeTop((View)this.mFabExpandLayout) - ViewUtils.getRelativeTop((View)this.mFab) - (this.mFab.getHeight() - this.getFabSizePx()) / 2;
        this.mFab.setAlpha(0.0f);
        this.mFab.setTranslationX(dx);
        this.mFab.setTranslationY(dy);
        this.mFab.setVisibility(0);
        int x = (int)ViewUtils.centerX((View)this.mFab);
        int y = (this.mFabExpandLayout.getBottom() - this.mFabExpandLayout.getTop()) / 2;
        float endRadius = this.getFabSizePx() / 2;
        float startRadius = (float)Math.hypot(Math.max(x, this.mFabExpandLayout.getWidth() - x), Math.max(y, this.mFabExpandLayout.getHeight() - y));
        ObjectAnimator fabSlideXAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFab, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{dx, 0.0f})});
        fabSlideXAnim.setStartDelay((long)(this.animationDuration / 2));
        fabSlideXAnim.setDuration((long)(this.animationDuration / 2));
        ObjectAnimator fabSlideYAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFab, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{dy, 0.0f})});
        fabSlideYAnim.setStartDelay((long)(this.animationDuration / 2));
        fabSlideYAnim.setDuration((long)(this.animationDuration / 2));
        Animator toolbarContractAnim = ViewAnimationUtils.createCircularReveal((View)this.mFabExpandLayout, (int)x, (int)y, (float)startRadius, (float)endRadius);
        toolbarContractAnim.setDuration((long)(this.animationDuration / 2));
        AnimatorSet animSet = new AnimatorSet();
        animSet.playTogether(new Animator[]{toolbarContractAnim, fabSlideXAnim, fabSlideYAnim});
        fabSlideXAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator(0.8f));
        fabSlideYAnim.setInterpolator((TimeInterpolator)new AccelerateInterpolator(1.0f));
        toolbarContractAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FooterLayout.this.mFab.setAlpha(1.0f);
                FooterLayout.this.mFabExpandLayout.setAlpha(0.0f);
            }
        });
        fabSlideYAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FooterLayout.this.mFabExpandLayout.setVisibility(4);
                FooterLayout.this.mFabExpandLayout.setAlpha(1.0f);
                FooterLayout.this.mAnimatingFab = false;
            }
        });
        animSet.start();
    }

    private void contractPreLollipop() {
        this.mAnimatingFab = true;
        float dx = ViewUtils.centerX((View)this.mFabExpandLayout) + (float)this.getFabSizePx() - ViewUtils.centerX((View)this.mFab);
        float dy = ViewUtils.getRelativeTop((View)this.mFabExpandLayout) - ViewUtils.getRelativeTop((View)this.mFab) - (this.mFab.getHeight() - this.getFabSizePx()) / 2;
        this.mFab.setAlpha(0.0f);
        this.mFab.setTranslationX(dx);
        this.mFab.setTranslationY(dy);
        this.mFab.setVisibility(0);
        int x = (int)ViewUtils.centerX((View)this.mFab);
        int y = (this.mFabExpandLayout.getBottom() - this.mFabExpandLayout.getTop()) / 2;
        float endRadius = this.getFabSizePx() / 2;
        float startRadius = (float)Math.hypot(Math.max(x, this.mFabExpandLayout.getWidth() - x), Math.max(y, this.mFabExpandLayout.getHeight() - y));
        ObjectAnimator fabSlideXAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFab, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{dx, 0.0f})});
        fabSlideXAnim.setDuration((long)(this.animationDuration / 2));
        ObjectAnimator fabSlideYAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFab, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_Y, (float[])new float[]{dy, 0.0f})});
        fabSlideYAnim.setDuration((long)(this.animationDuration / 2));
        SupportAnimator toolbarContractAnim = io.codetail.animation.ViewAnimationUtils.createCircularReveal((View)this.mFabExpandLayout, (int)x, (int)y, (float)startRadius, (float)endRadius);
        toolbarContractAnim.setDuration((long)(this.animationDuration / 2));
        final AnimatorSet animSet = new AnimatorSet();
        animSet.playTogether(new Animator[]{fabSlideXAnim, fabSlideYAnim});
        fabSlideXAnim.setInterpolator((TimeInterpolator)new DecelerateInterpolator(0.8f));
        fabSlideYAnim.setInterpolator((TimeInterpolator)new AccelerateInterpolator(1.0f));
        toolbarContractAnim.addListener(new SupportAnimator.AnimatorListener(){

            public void onAnimationStart() {
            }

            public void onAnimationEnd() {
                FooterLayout.this.mFab.setAlpha(1.0f);
                FooterLayout.this.mFabExpandLayout.setAlpha(0.0f);
                animSet.start();
            }

            public void onAnimationCancel() {
            }

            public void onAnimationRepeat() {
            }
        });
        fabSlideYAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FooterLayout.this.mFabExpandLayout.setVisibility(4);
                FooterLayout.this.mFabExpandLayout.setAlpha(1.0f);
                FooterLayout.this.mAnimatingFab = false;
            }
        });
        toolbarContractAnim.start();
    }

    private int getFabSizePx() {
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        return Math.round((float)this.mFabSize * (displayMetrics.xdpi / 160.0f));
    }
}

