/*
 * Decompiled with CFR 0.152.
 */
package com.bowyer.app.fabtransitionlayout;

import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Build;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import com.bowyer.app.fabtransitionlayout.FooterLayout;
import java.util.List;

public class FooterBehavior
extends CoordinatorLayout.Behavior<FooterLayout> {
    private static final boolean SNACKBAR_BEHAVIOR_ENABLED = Build.VERSION.SDK_INT >= 11;
    private ValueAnimator mTranslationYAnimator;
    private float mFooterTranslationY;

    public FooterBehavior() {
    }

    public FooterBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void onNestedScroll(CoordinatorLayout coordinatorLayout, FooterLayout child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        super.onNestedScroll(coordinatorLayout, (View)child, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
        if (dyConsumed > 0) {
            child.contractFab();
        } else if (dyConsumed < 0) {
            child.contractFab();
        }
    }

    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, FooterLayout child, View directTargetChild, View target, int nestedScrollAxes) {
        return nestedScrollAxes == 2 || super.onStartNestedScroll(coordinatorLayout, (View)child, directTargetChild, target, nestedScrollAxes);
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, FooterLayout child, View dependency) {
        return SNACKBAR_BEHAVIOR_ENABLED && dependency instanceof Snackbar.SnackbarLayout;
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, FooterLayout child, View dependency) {
        if (dependency instanceof Snackbar.SnackbarLayout) {
            this.updateTranslationForSnackbar(parent, child);
        }
        return false;
    }

    private void updateTranslationForSnackbar(CoordinatorLayout parent, FooterLayout footerLayout) {
        float targetTransY = this.getTranslationYForSnackbar(parent, footerLayout);
        if (this.mFooterTranslationY == targetTransY) {
            return;
        }
        float currentTransY = ViewCompat.getTranslationY((View)footerLayout);
        if (this.mTranslationYAnimator != null && this.mTranslationYAnimator.isRunning()) {
            this.mTranslationYAnimator.cancel();
        }
        if (footerLayout.isShown() && Math.abs(currentTransY - targetTransY) > (float)footerLayout.getHeight() * 0.667f) {
            this.mTranslationYAnimator.setFloatValues(new float[]{currentTransY, targetTransY});
            this.mTranslationYAnimator.start();
        } else {
            ViewCompat.setTranslationY((View)footerLayout, (float)targetTransY);
        }
        this.mFooterTranslationY = targetTransY;
    }

    private float getTranslationYForSnackbar(CoordinatorLayout parent, FooterLayout footerLayout) {
        float minOffset = 0.0f;
        List dependencies = parent.getDependencies((View)footerLayout);
        int z = dependencies.size();
        for (int i = 0; i < z; ++i) {
            View view = (View)dependencies.get(i);
            if (!(view instanceof Snackbar.SnackbarLayout) || !parent.doViewsOverlap((View)footerLayout, view)) continue;
            minOffset = Math.min(minOffset, ViewCompat.getTranslationY((View)view) - (float)view.getHeight());
        }
        return minOffset;
    }
}

