/*
 * Decompiled with CFR 0.152.
 */
package com.bowyer.app.fabtoolbar;

import android.graphics.Point;
import android.graphics.PointF;
import android.view.animation.Animation;
import android.view.animation.Transformation;

public class ArcTranslateAnimation
extends Animation {
    private int mCenterXType;
    private int mCenterYType;
    private float mCenterXValue;
    private float mCenterYValue;
    private float mRadius;
    private Point mStartPoint;
    private float mDeltaRad;
    private float mStartRad;
    private float mEndRad;

    public ArcTranslateAnimation(int startDegrees, int endDegrees, int centerXType, float centerXValue, int centerYType, float centerYValue) {
        this.mStartRad = (float)((double)startDegrees * Math.PI / 180.0);
        this.mEndRad = (float)((double)endDegrees * Math.PI / 180.0);
        this.mCenterXType = centerXType;
        this.mCenterXValue = centerXValue;
        this.mCenterYType = centerYType;
        this.mCenterYValue = centerYValue;
    }

    private PointF getArcPoint(float interpolatedTime) {
        float rad = this.mStartRad + (this.mEndRad - this.mStartRad) * interpolatedTime + this.mDeltaRad;
        float dx = (float)(Math.cos(rad) * (double)this.mRadius);
        float dy = (float)(Math.sin(rad) * (double)this.mRadius);
        return new PointF(dx - (float)this.mStartPoint.x, dy - (float)this.mStartPoint.y);
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        PointF p = this.getArcPoint(interpolatedTime);
        t.getMatrix().postTranslate(p.x, p.y);
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        float fromX = this.resolveSize(0, 0.0f, width, parentWidth);
        float fromY = this.resolveSize(0, 0.0f, height, parentHeight);
        float centerX = this.resolveSize(this.mCenterXType, this.mCenterXValue, width, parentWidth);
        float centerY = this.resolveSize(this.mCenterYType, this.mCenterYValue, height, parentHeight);
        this.mDeltaRad = (float)Math.atan2(fromY - centerY, fromX - centerX);
        this.mRadius = (float)Math.sqrt(Math.pow(fromX - centerX, 2.0) + Math.pow(fromY - centerY, 2.0));
        this.mStartPoint = new Point((int)(fromX - centerX), (int)(fromY - centerY));
    }
}

