/*
 * Decompiled with CFR 0.152.
 */
package com.bowyer.app.fabtoolbar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.view.animation.FastOutLinearInInterpolator;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.bowyer.app.fabtoolbar.R;
import com.bowyer.app.fabtoolbar.ViewUtils;

public class FabToolbar
extends FrameLayout {
    private static final int DEFAULT_ANIMATION_DURATION = 600;
    private int animationDuration = 600;
    private ImageView mFab;
    private LinearLayout mFabExpandLayout;
    private static final int FAB_CIRCLE = 0;
    private static final int FAB_EXPAND = 1;
    int mFabType = 0;
    boolean mAnimatingFab = false;

    public FabToolbar(Context context) {
        super(context);
        this.init();
    }

    public FabToolbar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        this.loadAttributes(context, attrs);
    }

    public FabToolbar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
        this.loadAttributes(context, attrs);
    }

    private void init() {
        FabToolbar.inflate((Context)this.getContext(), (int)R.layout.fab_toolbar, (ViewGroup)this);
        this.mFabExpandLayout = (LinearLayout)this.findViewById(R.id.container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributes(Context context, AttributeSet attrs) {
        int containerGravity;
        TypedValue outValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(R.attr.colorPrimary, outValue, true);
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.FabToolbar, 0, 0);
        try {
            this.setColor(a.getColor(R.styleable.FabToolbar_tb_color, outValue.data));
            this.animationDuration = a.getInteger(R.styleable.FabToolbar_tb_anim_duration, 600);
            containerGravity = a.getInteger(R.styleable.FabToolbar_tb_container_gravity, 1);
        }
        finally {
            a.recycle();
        }
        this.mFabExpandLayout.setGravity(this.getGravity(containerGravity));
    }

    public void setFab(ImageView imageView) {
        this.mFab = imageView;
    }

    private int getGravity(int gravityEnum) {
        return (gravityEnum == 0 ? 0x800003 : (gravityEnum == 1 ? 1 : 0x800005)) | 0x10;
    }

    public void setColor(int color) {
        this.mFabExpandLayout.setBackgroundColor(color);
    }

    public void addView(@NonNull View child) {
        if (this.canAddViewToContainer(child)) {
            this.mFabExpandLayout.addView(child);
        } else {
            super.addView(child);
        }
    }

    public void addView(@NonNull View child, int width, int height) {
        if (this.canAddViewToContainer(child)) {
            this.mFabExpandLayout.addView(child, width, height);
        } else {
            super.addView(child, width, height);
        }
    }

    public void addView(@NonNull View child, ViewGroup.LayoutParams params) {
        if (this.canAddViewToContainer(child)) {
            this.mFabExpandLayout.addView(child, params);
        } else {
            super.addView(child, params);
        }
    }

    public void addView(@NonNull View child, int index, ViewGroup.LayoutParams params) {
        if (this.canAddViewToContainer(child)) {
            this.mFabExpandLayout.addView(child, index, params);
        } else {
            super.addView(child, index, params);
        }
    }

    private boolean canAddViewToContainer(View child) {
        return this.mFabExpandLayout != null;
    }

    public void showFab() {
        if (this.isExpandFab()) {
            this.mFabExpandLayout.setVisibility(0);
        } else {
            this.mFab.setVisibility(0);
        }
    }

    public void hideFab() {
        if (this.isExpandFab()) {
            this.mFabExpandLayout.setVisibility(4);
        } else {
            this.mFab.setVisibility(4);
        }
    }

    private void fadeInFab() {
        if (this.mAnimatingFab) {
            return;
        }
        this.mAnimatingFab = true;
        boolean isExpandFab = this.isExpandFab();
        LinearLayout fab = isExpandFab ? this.mFabExpandLayout : this.mFab;
        fab.setAlpha(0.0f);
        if (isExpandFab) {
            fab.setTranslationY((float)fab.getHeight());
        } else {
            fab.setScaleX(0.0f);
            fab.setScaleY(0.0f);
        }
        fab.setVisibility(0);
        ViewPropertyAnimator anim = fab.animate().setStartDelay(1000L).setDuration(300L).setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator()).alpha(1.0f);
        if (isExpandFab) {
            anim.translationY(0.0f);
        } else {
            anim.scaleX(1.0f).scaleY(1.0f);
        }
        anim.setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FabToolbar.this.mAnimatingFab = false;
            }
        }).start();
    }

    public void slideInFab() {
        if (this.mAnimatingFab) {
            return;
        }
        if (this.isExpandFab()) {
            this.contractFab();
            return;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mFab.getLayoutParams();
        float dy = this.mFab.getHeight() + lp.bottomMargin;
        if (this.mFab.getTranslationY() != dy) {
            return;
        }
        this.mAnimatingFab = true;
        this.mFab.setVisibility(0);
        this.mFab.animate().setStartDelay(0L).setDuration(200L).setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator()).translationY(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FabToolbar.this.mAnimatingFab = false;
            }
        }).start();
    }

    public void slideOutFab() {
        if (this.mAnimatingFab) {
            return;
        }
        if (this.isExpandFab()) {
            this.contractFab();
            return;
        }
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mFab.getLayoutParams();
        if (this.mFab.getTranslationY() != 0.0f) {
            return;
        }
        this.mAnimatingFab = true;
        this.mFab.animate().setStartDelay(0L).setDuration(200L).setInterpolator((TimeInterpolator)new FastOutLinearInInterpolator()).translationY((float)(this.mFab.getHeight() + lp.bottomMargin)).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FabToolbar.this.mAnimatingFab = false;
                FabToolbar.this.mFab.setVisibility(4);
            }
        }).start();
    }

    public void expandFab() {
        if (Build.VERSION.SDK_INT < 21) {
            this.hideFab();
            this.mFabType = 1;
            this.showFab();
            return;
        }
        this.mAnimatingFab = true;
        this.mFabType = 1;
        float dx = ViewUtils.centerX((View)this.mFabExpandLayout) + (float)this.mFab.getWidth() - ViewUtils.centerX((View)this.mFab);
        float dy = ViewUtils.centerY((View)this.mFabExpandLayout);
        ObjectAnimator slideFadeOutXAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFab, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{0.0f, dx}), PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{1.0f, 0.0f})});
        slideFadeOutXAnim.setDuration(200L);
        ObjectAnimator slideFadeOutYAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFab, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{0.0f, dy})});
        slideFadeOutYAnim.setDuration(200L);
        slideFadeOutYAnim.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.mFabExpandLayout.setAlpha(0.0f);
        this.mFabExpandLayout.setTranslationX((float)this.mFab.getWidth());
        ObjectAnimator slideFadeInAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFabExpandLayout, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{this.mFab.getWidth(), 0.0f}), PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f})});
        slideFadeInAnim.setStartDelay(150L);
        slideFadeInAnim.setDuration(50L);
        int x = (this.mFabExpandLayout.getRight() - this.mFabExpandLayout.getLeft()) / 2;
        int y = (this.mFabExpandLayout.getBottom() - this.mFabExpandLayout.getTop()) / 2;
        float startRadius = 1.0f * (float)this.mFab.getWidth() / 2.0f;
        float endRadius = (float)Math.hypot(Math.max(x, this.mFabExpandLayout.getWidth() - x), Math.max(y, this.mFabExpandLayout.getHeight() - y));
        Animator revealAnim = ViewAnimationUtils.createCircularReveal((View)this.mFabExpandLayout, (int)x, (int)y, (float)startRadius, (float)endRadius);
        revealAnim.setStartDelay(150L);
        revealAnim.setDuration(150L);
        AnimatorSet animSet = new AnimatorSet();
        animSet.playTogether(new Animator[]{slideFadeOutXAnim, slideFadeOutYAnim, slideFadeInAnim, revealAnim});
        animSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                FabToolbar.this.mFabExpandLayout.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FabToolbar.this.mFab.setVisibility(4);
                FabToolbar.this.mFab.setTranslationX(0.0f);
                FabToolbar.this.mFab.setTranslationY(0.0f);
                FabToolbar.this.mFab.setAlpha(1.0f);
                FabToolbar.this.mAnimatingFab = false;
            }
        });
        animSet.start();
    }

    public void contractFab() {
        if (!this.isExpandFab()) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            this.hideFab();
            this.mFabType = 0;
            this.showFab();
            return;
        }
        this.mAnimatingFab = true;
        this.mFabType = 0;
        int x = (this.mFabExpandLayout.getRight() - this.mFabExpandLayout.getLeft()) / 2;
        int y = (this.mFabExpandLayout.getBottom() - this.mFabExpandLayout.getTop()) / 2;
        float endRadius = 1.0f * (float)this.mFab.getWidth() / 2.0f;
        float startRadius = (float)Math.hypot(Math.max(x, this.mFabExpandLayout.getWidth() - x), Math.max(y, this.mFabExpandLayout.getHeight() - y));
        Animator revealAnim = ViewAnimationUtils.createCircularReveal((View)this.mFabExpandLayout, (int)x, (int)y, (float)startRadius, (float)endRadius);
        revealAnim.setDuration(200L);
        ObjectAnimator slideFadeOutAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFabExpandLayout, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{0.0f, this.mFab.getWidth()}), PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{1.0f, 0.0f})});
        slideFadeOutAnim.setStartDelay(150L);
        slideFadeOutAnim.setDuration(50L);
        float dx = ViewUtils.centerX((View)this.mFabExpandLayout) + (float)this.mFab.getWidth() - ViewUtils.centerX((View)this.mFab);
        float dy = ViewUtils.centerY((View)this.mFabExpandLayout);
        this.mFab.setTranslationX(dx);
        this.mFab.setTranslationY(dy);
        this.mFab.setAlpha(0.0f);
        ObjectAnimator slideFadeInXAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFab, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{dx, 0.0f}), PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f})});
        slideFadeInXAnim.setStartDelay(150L);
        slideFadeInXAnim.setDuration(150L);
        ObjectAnimator slideFadeInYAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.mFab, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{dy, 0.0f})});
        slideFadeInYAnim.setStartDelay(150L);
        slideFadeInYAnim.setDuration(150L);
        slideFadeInYAnim.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        AnimatorSet animSet = new AnimatorSet();
        animSet.playTogether(new Animator[]{revealAnim, slideFadeOutAnim, slideFadeInXAnim, slideFadeInYAnim});
        animSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                FabToolbar.this.mFab.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FabToolbar.this.mFabExpandLayout.setVisibility(4);
                FabToolbar.this.mFabExpandLayout.setAlpha(1.0f);
                FabToolbar.this.mFabExpandLayout.setTranslationX(0.0f);
                FabToolbar.this.mAnimatingFab = false;
            }
        });
        animSet.start();
    }

    private boolean isExpandFab() {
        return this.mFabType == 1;
    }

    private static @interface Fab {
    }
}

