/*
 * Decompiled with CFR 0.152.
 */
package com.example.library;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import com.example.library.FocusResizeAdapter;

public class FocusResizeScrollListener<T extends FocusResizeAdapter>
extends RecyclerView.OnScrollListener {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private int heightCollapsedItem;
    private int heightExpandedItem;
    private int itemToResize;
    private boolean init = false;
    private LinearLayoutManager mLinearLayoutManager;
    private int dyAbs;
    private T adapter;

    public FocusResizeScrollListener(T adapter, LinearLayoutManager linearLayoutManager) {
        this.adapter = adapter;
        this.heightCollapsedItem = ((FocusResizeAdapter)((Object)adapter)).getHeight();
        this.heightExpandedItem = this.heightCollapsedItem * 3;
        this.mLinearLayoutManager = linearLayoutManager;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        try {
            if (this.mLinearLayoutManager.getOrientation() == 1) {
                this.dyAbs = Math.abs(dy);
                int totalItemCount = this.mLinearLayoutManager.getItemCount();
                this.itemToResize = dy > 0 ? 1 : 0;
                this.initFocusResize(recyclerView);
                this.calculateScrolledPosition(totalItemCount, recyclerView);
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)e.getMessage());
        }
    }

    private void calculateScrolledPosition(int totalItemCount, RecyclerView recyclerView) {
        for (int j = 0; j < totalItemCount - 1; ++j) {
            View view = recyclerView.getChildAt(j);
            if (view == null || recyclerView.getChildViewHolder(view) instanceof FocusResizeAdapter.FooterViewHolder) continue;
            if (j == this.itemToResize) {
                this.onItemBigResize(view, recyclerView);
            } else {
                this.onItemSmallResize(view, recyclerView);
            }
            view.requestLayout();
        }
    }

    private void onItemSmallResize(View view, RecyclerView recyclerView) {
        if (view.getLayoutParams().height - this.dyAbs <= this.heightCollapsedItem) {
            view.getLayoutParams().height = this.heightCollapsedItem;
        } else if (view.getLayoutParams().height >= this.heightCollapsedItem) {
            view.getLayoutParams().height -= this.dyAbs * 2;
        }
        ((FocusResizeAdapter)((Object)this.adapter)).onItemSmallResize(recyclerView.getChildViewHolder(view), this.itemToResize, this.dyAbs);
    }

    private void onItemBigResize(View view, RecyclerView recyclerView) {
        view.getLayoutParams().height = view.getLayoutParams().height + this.dyAbs >= this.heightExpandedItem ? this.heightExpandedItem : (view.getLayoutParams().height += this.dyAbs * 2);
        ((FocusResizeAdapter)((Object)this.adapter)).onItemBigResize(recyclerView.getChildViewHolder(view), this.itemToResize, this.dyAbs);
    }

    private void initFocusResize(RecyclerView recyclerView) {
        if (!this.init) {
            this.init = true;
            View view = recyclerView.getChildAt(0);
            view.getLayoutParams().height = this.heightExpandedItem;
            ((FocusResizeAdapter)((Object)this.adapter)).onItemInit(recyclerView.getChildViewHolder(view));
        }
    }

    private int calculatePositionScrolledDown(RecyclerView recyclerView) {
        int positionScrolled;
        if (this.mLinearLayoutManager.findFirstCompletelyVisibleItemPosition() == this.mLinearLayoutManager.getItemCount() - 1) {
            positionScrolled = this.itemToResize - 1;
            this.mLinearLayoutManager.scrollToPositionWithOffset(this.mLinearLayoutManager.findFirstVisibleItemPosition(), 0);
        } else if (recyclerView.getChildAt(this.itemToResize).getHeight() > recyclerView.getChildAt(this.itemToResize - 1).getHeight()) {
            positionScrolled = this.itemToResize;
            this.mLinearLayoutManager.scrollToPositionWithOffset(this.mLinearLayoutManager.findFirstCompletelyVisibleItemPosition(), 0);
        } else {
            positionScrolled = this.itemToResize - 1;
            this.mLinearLayoutManager.scrollToPositionWithOffset(this.mLinearLayoutManager.findFirstVisibleItemPosition(), 0);
        }
        return positionScrolled;
    }

    private int calculatePositionScrolledUp(RecyclerView recyclerView) {
        int positionScrolled;
        if (recyclerView.getChildAt(this.itemToResize).getHeight() > recyclerView.getChildAt(this.itemToResize + 1).getHeight()) {
            positionScrolled = this.itemToResize;
            this.mLinearLayoutManager.scrollToPositionWithOffset(this.mLinearLayoutManager.findFirstVisibleItemPosition(), 0);
        } else {
            positionScrolled = this.itemToResize + 1;
            this.mLinearLayoutManager.scrollToPositionWithOffset(this.mLinearLayoutManager.findFirstCompletelyVisibleItemPosition(), 0);
        }
        return positionScrolled;
    }

    private void forceScrollItem(RecyclerView recyclerView, View view, int j, int positionScrolled) {
        if (!(recyclerView.getChildViewHolder(view) instanceof FocusResizeAdapter.FooterViewHolder)) {
            if (j == positionScrolled) {
                view.getLayoutParams().height = this.heightExpandedItem;
                ((FocusResizeAdapter)((Object)this.adapter)).onItemBigResizeScrolled(recyclerView.getChildViewHolder(view), this.itemToResize, this.dyAbs);
            } else if (this.mLinearLayoutManager.findFirstCompletelyVisibleItemPosition() == this.mLinearLayoutManager.getItemCount() - 1 || this.mLinearLayoutManager.findFirstCompletelyVisibleItemPosition() == -1) {
                view.getLayoutParams().height = this.heightExpandedItem;
                ((FocusResizeAdapter)((Object)this.adapter)).onItemBigResizeScrolled(recyclerView.getChildViewHolder(view), this.itemToResize, this.dyAbs);
            } else {
                view.getLayoutParams().height = this.heightCollapsedItem;
                ((FocusResizeAdapter)((Object)this.adapter)).onItemSmallResizeScrolled(recyclerView.getChildViewHolder(view), this.itemToResize, this.dyAbs);
            }
        }
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        try {
            if (newState == 0 && this.mLinearLayoutManager.getOrientation() == 1) {
                int positionScrolled = this.itemToResize == 1 ? this.calculatePositionScrolledDown(recyclerView) : this.calculatePositionScrolledUp(recyclerView);
                for (int j = 0; j < this.mLinearLayoutManager.getItemCount() - 1; ++j) {
                    View view = recyclerView.getChildAt(j);
                    if (view == null) continue;
                    this.forceScrollItem(recyclerView, view, j, positionScrolled);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)e.getMessage());
        }
    }
}

