/*
 * Decompiled with CFR 0.152.
 */
package com.example.library;

import android.app.Activity;
import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.example.library.R;
import com.example.library.Utils;

public abstract class FocusResizeAdapter<T extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<T> {
    private static final int VIEW_TYPE_FOOTER = 1;
    private Context context;
    private int height;

    public FocusResizeAdapter(Context context, int height) {
        this.context = context;
        this.height = height;
    }

    public T onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            return (T)((Object)new FooterViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_footer, parent, false)));
        }
        return this.onCreateFooterViewHolder(parent, viewType);
    }

    public final void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        if (position != this.getFooterItemCount()) {
            this.onBindFooterViewHolder(viewHolder, position);
        }
    }

    public final int getItemCount() {
        if (this.getFooterItemCount() == 0) {
            return 0;
        }
        return this.getFooterItemCount() + 1;
    }

    public final int getItemViewType(int position) {
        if (position != 0 && position == this.getItemCount() - 1) {
            return 1;
        }
        return this.getItemFooterViewType(position);
    }

    public abstract void onItemBigResize(RecyclerView.ViewHolder var1, int var2, int var3);

    public abstract void onItemBigResizeScrolled(RecyclerView.ViewHolder var1, int var2, int var3);

    public abstract void onItemSmallResizeScrolled(RecyclerView.ViewHolder var1, int var2, int var3);

    public abstract void onItemSmallResize(RecyclerView.ViewHolder var1, int var2, int var3);

    public abstract void onItemInit(RecyclerView.ViewHolder var1);

    public int getItemFooterViewType(int position) {
        return 0;
    }

    public abstract int getFooterItemCount();

    public abstract T onCreateFooterViewHolder(ViewGroup var1, int var2);

    public abstract void onBindFooterViewHolder(T var1, int var2);

    public int getHeight() {
        return this.height;
    }

    public class FooterViewHolder
    extends RecyclerView.ViewHolder {
        public FooterViewHolder(View v) {
            super(v);
            v.getLayoutParams().height = Utils.getFooterHeight((Activity)FocusResizeAdapter.this.context, FocusResizeAdapter.this.height * 3);
        }
    }
}

